//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2022
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_INTEGRATION_SUPPORT_H
#define TEMU_INTEGRATION_SUPPORT_H

#include "temu-c/Memory/Memory.h"
#include "temu-c/Support/Objsys.h"

#ifdef __cplusplus
extern "C" {
#endif

/*!
  Device ID Memory Access Interface

  This interface mirrors the memory access interface, but takes an additional
  device id parameter to be filled in by the DeviceIdIntegrator class.
*/
typedef struct temu_DeviceIdMemAccessIface {
  //! Called when fetching an instruction
  void (*fetch)(void *Obj, uint32_t DeviceID, temu_MemTransaction *MT);
  //! Called when reading data
  void (*read)(void *Obj, uint32_t DeviceID, temu_MemTransaction *MT);
  //! Called when writing data
  void (*write)(void *Obj, uint32_t DeviceID, temu_MemTransaction *MT);
} temu_DeviceIdMemAccessIface;
#define TEMU_DEVICE_ID_MEM_ACCESS_IFACE_TYPE "temu::DeviceIdMemAccessIface"
TEMU_IFACE_REFERENCE_TYPE(temu_DeviceIdMemAccess);

/*!
   Device ID Interface

   This interface enables an external simulator to attach a device ID handler in
   the DeviceIdIntegrator.
 */

typedef struct temu_DeviceIdIface {
  //! Attach external device
  void (*attach)(void *Obj, uint32_t DeviceID, void *UserPtr,
                 temu_DeviceIdMemAccessIface *UserIface);
} temu_DeviceIdIface;
#define TEMU_DEVICE_ID_IFACE_TYPE "temu::DeviceIdIface"
TEMU_IFACE_REFERENCE_TYPE(temu_DeviceId);

#ifdef __cplusplus
}
#endif

#endif /* ! TEMU_INTEGRATION_SUPPORT_H */
