//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2016
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_MODELS_DATALOGGER
#define TEMU_MODELS_DATALOGGER

#include <stdint.h>
#include "temu-c/Support/Objsys.h"

#ifdef __cplusplus
extern "C" {
#endif

/*!
  Simple interface to get recorded line data from e.g. the console model.
 */

typedef struct temu_LineDataLoggerIface {
  //! Get number of lines
  uint64_t (*getLineCount)(void *Obj);
  //! Get pointer to line string
  const char* (*getLine)(void *Obj, uint64_t Line);
} temu_LineDataLoggerIface;
#define TEMU_LINE_DATA_LOGGER_IFACE_TYPE "LineDataLoggerIface"
TEMU_IFACE_REFERENCE_TYPE(temu_LineDataLogger);


#ifdef __cplusplus
}
#endif

#endif /* ! TEMU_MODELS_CONSOLE */
