//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2016
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

// This file contains all the public VTables used. Note that even
// though this is a public header, the code here is UNSTABLE. That is,
// the structures may change without notice (though not between bug
// fix releases).
//
// For that reason use this with care and only for code where it is
// unpractical for you to use interfaces directly.

#ifndef TEMU_SUPPORT_VTABLE_H
#define TEMU_SUPPORT_VTABLE_H

#include "temu-c/Models/Machine.h"
#include "temu-c/Support/Events.h"
#include "temu-c/Models/IrqController.h"
#include "temu-c/Memory/Memory.h"
#include "temu-c/Models/Clock.h"

#ifdef __cplusplus
extern "C" {
#endif

// Typically you would call:
//   temu_setVTable(Cls, &MyVT);
//   temu_qualifyAsMachine/Cpu/Memory(Cls);
// In your machine implementation.

/*!
 * All processors provide the CpuVTable
 */
typedef struct {
  temu_CpuIface *Cpu;                 //!< CPU interface
  temu_IrqCtrlIface *Irq;             //!< IRQ interface
  temu_MemAccessIface *InvalidAccess; //!< Invalid memory access interface
  temu_ClockIface *Clock;             //!< Clock interface
  temu_BinaryTranslationControlIface *Translation; //!< Binary translator control interface
} temu_CpuVTable;


/*!
 * All machines must implement this VTable interface.
 * These are used to speedup certain operations on machine objects.
 */
typedef struct {
  temu_MachineIface *Machine; //!< Machine interface
} temu_MachineVTable;

//! Fast memory operations
typedef struct {
  temu_MemAccessIface *MemAccess; //!< Memory access interface
  temu_MemoryIface *Memory;       //!< Memory interface (deprecated)
  temu_PDCIface *PDC;             //!< Pre-decode cache interface
} temu_MemVTable;

#ifdef __cplusplus
}
#endif

#endif /* ! TEMU_SUPPORT_VTABLE_H */
