//===-- temu-c/Support/Version.h - TEMU Version API -------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2022
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//


#ifndef TEMU_VERSION_H
#define TEMU_VERSION_H
#include "temu-c/Support/Attributes.h"
#ifdef __cplusplus
extern "C" {
#endif

/*!
 * Get TEMU version string.
 * \result Version string in format like: <MAJOR>.<MINOR>.<PATCH> (<REVISION>)
 */
TEMU_API const char *temu_getVersionString(void);

/*!
 * Get TEMU major version as number.
 * \result Major version number
 */
TEMU_API unsigned temu_getMajorVersion(void);

/*!
 * Get TEMU minor version as number.
 * \result Minor version number
 */
TEMU_API unsigned temu_getMinorVersion(void);

/*!
 * Get TEMU patch version as number.
 * \result Patch version number
 */
TEMU_API unsigned temu_getPatchVersion(void);

#ifdef __cplusplus
}
#endif

#endif // !TEMU_VERSION_H
