#!/bin/bash

if ! [ $(id -u) = 0 ]; then
   echo "The script need to be run as root." >&2
   exit 1
fi

if [ $SUDO_USER ]; then
    real_user=$SUDO_USER
else
    real_user=$(whoami)
fi
export BASE_PATH="/var/lib/"

echo "Starting TEMU setup for $real_user"

# create group if not exist
getent group temu || groupadd temu

# add user to group
usermod -a -G temu $real_user

cd $BASE_PATH

echo "Creating folder  $BASE_PATH/temu/licenses/$real_user"
mkdir -p temu/licenses/$real_user
cd temu/

chgrp temu licenses
chmod 770  licenses

cd licenses

touch com.terma.auditlog
chgrp temu com.terma.auditlog
chmod 770  com.terma.auditlog

chgrp temu $real_user
chmod 770  $real_user