#include <stdint.h>
#include <stdio.h>
#include <string.h>

#include "temu-c/Support/Objsys.h"
#include "temu-c/Support/Logging.h"
#include "temu-c/Memory/Memory.h"


typedef struct {
  temu_Object Super;

  uint32_t RegisterA;
} MMIOModel;

void*
create(const char *Name, int Argc, const temu_CreateArg *Argv)
{
  void *Obj = malloc(sizeof(MMIOModel));
  memset(Obj, 0, sizeof(MMIOModel));
  return Obj;
}

void
destroy(void *Obj)
{
  free(Obj);
}

void
regAWrite(void *Obj, temu_Propval Pv, int Idx)
{
  MMIOModel *MMIO = (MMIOModel*)Obj;
  temu_logInfo(Obj, "writing register a");
  MMIO->RegisterA = temu_propValueU32(Pv);
}

temu_Propval
regARead(void *Obj, int Idx)
{
  MMIOModel *MMIO = (MMIOModel*)Obj;
  temu_logInfo(Obj, "reading register a");
  return temu_makePropU32(MMIO->RegisterA);
}

void
memRead(void *Obj, temu_MemTransaction *Mt)
{
  MMIOModel *MMIO = (MMIOModel*)Obj;

  switch (Mt->Offset) {
  case 0x0:
    Mt->Value = temu_propValueU32(regARead(MMIO, 0));
    break;
  default:
    temu_logError(MMIO, "read from non-existing register");
  }

  Mt->Cycles = 1; // Access cost
}

void
memWrite(void *Obj, temu_MemTransaction *Mt)
{
  MMIOModel *MMIO = (MMIOModel*)Obj;

  temu_Propval Pv = temu_makePropU32(Mt->Value);

  switch (Mt->Offset) {
  case 0x0:
    regAWrite(MMIO, Pv, 0);
    break;
  default:
    temu_logError(MMIO, "write to non-existing register");
  }

  Mt->Cycles = 1;
}


temu_MemAccessIface MemAccessIface = {
  NULL,     // Illegal, cannot fetch from this device model
  memRead,
  memWrite,
};


TEMU_PLUGIN_INIT
{
  temu_Class *Cls = temu_registerClass("MMIOModel",
                                       create,
                                       destroy);
  temu_addProperty(Cls, "regA",
                   offsetof(MMIOModel,RegisterA),
                   teTY_U32,
                   1,
                   regAWrite,
                   regARead,
                   "Register A triggers foo");

  temu_addInterface(Cls,
                    "MemAccessIface", // Interface name
                    "MemAccessIface", // Interface type name
                    &MemAccessIface,
                    1, // Reserved for future, pass 1 for now
                    "My Interface is used for MMIO transactions");
}
