#include <stdint.h>
#include <stdio.h>
#include <string.h>

#include "temu-c/Support/Objsys.h"

typedef struct {
  temu_Object Super;

  uint32_t MyScalar;
  uint32_t MyArray[2];
} MySimpleClass;

void*
createMySimpleObject(const char *Name, int Argc, const temu_CreateArg *Argv)
{
  void *Obj = malloc(sizeof(MySimpleClass));
  memset(Obj, 0, sizeof(MySimpleClass));

  printf("Creating Object '%s'\n", Name);
  for (int i = 0 ; i < Argc ; ++i) {
    printf("  arg %d : %s\n", i, Argv[i].Key);
  }

  return Obj;
}

void
destroyMySimpleObject(void *Obj)
{
  free(Obj);
}

void
scalarWrite(void *Obj, temu_Propval Pv, int Idx)
{
  MySimpleClass *MS = (MySimpleClass*)Obj;
  printf("writing scalar property\n");
  MS->MyScalar = temu_propValueU32(Pv);
}

temu_Propval
scalarRead(void *Obj, int Idx)
{
  MySimpleClass *MS = (MySimpleClass*)Obj;
  printf("reading scalar property\n");
  return temu_makePropU32(MS->MyScalar);
}

void
arrayWrite(void *Obj, temu_Propval Pv, int Idx)
{
  MySimpleClass *MS = (MySimpleClass*)Obj;
  printf("writing array property at index %d\n", Idx);
  MS->MyArray[Idx] = temu_propValueU32(Pv);
}

temu_Propval
arrayRead(void *Obj, int Idx)
{
  MySimpleClass *MS = (MySimpleClass*)Obj;
  printf("reading array property at index %d\n", Idx);
  return temu_makePropU32(MS->MyArray[Idx]);
}




TEMU_PLUGIN_INIT
{
  temu_Class *Cls = temu_registerClass("MyClass",
                                       createMySimpleObject,
                                       destroyMySimpleObject);
  temu_addProperty(Cls, "myScalar",
                   offsetof(MySimpleClass,MyScalar),
                   teTY_U32,
                   1, // Number of elements (1 = scalar)
                   scalarWrite,
                   scalarRead,
                   "Scalar is used for smurfing 42 smurfs");

  temu_addProperty(Cls, "myArray",
                   offsetof(MySimpleClass,MyArray),
                   teTY_U32,
                   2, // Number of elements (1 = scalar)
                   arrayWrite,
                   arrayRead,
                   "Array is used for smurfing 42 smurfs as well");

}
