from ctypes import *
TEMUSupport = CDLL('libTEMUSupport.so.4')


class Buff(Structure):
  pass
Buff._fields_ = [ 
    ('data0', c_ulong),
    ('data1', c_uint32),
    ('data2', c_uint32)  ]

class Component(Structure):
  pass
Component._fields_ = [  ]


class Class(Structure):
  pass
Class._fields_ = [  ]


class TimeSource(Structure):
  pass
TimeSource._fields_ = [  ]


class Object(Structure):
  pass
Object._fields_ = [ 
    ('Class', POINTER(Class)),
    ('Name', c_char_p),
    ('TimeSource', POINTER(TimeSource)),
    ('Component', POINTER(Component)),
    ('LoggingFlags', c_uint64),
    ('WillDisposeNotification', c_int64),
    ('DisposedNotification', c_int64),
    ('UserData', c_void_p),
    ('IsClassObject', c_uint64),
    ('IsCheckpointable', c_uint64),
    ('IsTimeSource', c_uint64),
    ('TraceMemoryReads', c_uint64),
    ('TraceMemoryWrites', c_uint64),
    ('BreakOnMemoryRead', c_uint64),
    ('BreakOnMemoryWrite', c_uint64)  ]


class IfaceRef(Structure):
  pass
IfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', c_void_p)  ]


class IfaceRefArray(Structure):
  pass
IfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(IfaceRef))  ]

ifaceRefArrayAlloc = TEMUSupport.temu_ifaceRefArrayAlloc
ifaceRefArrayAlloc.argtypes = [c_uint]
ifaceRefArrayAlloc.restype = IfaceRefArray

ifaceRefArrayPush2 = TEMUSupport.temu_ifaceRefArrayPush2
ifaceRefArrayPush2.argtypes = [POINTER(IfaceRefArray), POINTER(Object), c_void_p]
ifaceRefArrayPush2.restype = None

ifaceRefArrayPush = TEMUSupport.temu_ifaceRefArrayPush
ifaceRefArrayPush.argtypes = [POINTER(IfaceRefArray), IfaceRef]
ifaceRefArrayPush.restype = None

ifaceRefArraySize = TEMUSupport.temu_ifaceRefArraySize
ifaceRefArraySize.argtypes = [POINTER(IfaceRefArray)]
ifaceRefArraySize.restype = c_uint

ifaceRefArrayGet = TEMUSupport.temu_ifaceRefArrayGet
ifaceRefArrayGet.argtypes = [POINTER(IfaceRefArray), c_uint]
ifaceRefArrayGet.restype = IfaceRef

ifaceRefArrayDispose = TEMUSupport.temu_ifaceRefArrayDispose
ifaceRefArrayDispose.argtypes = [POINTER(IfaceRefArray)]
ifaceRefArrayDispose.restype = None


class i8Array(Structure):
  pass
i8Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_int8))  ]

class i16Array(Structure):
  pass
i16Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_int16))  ]

class i32Array(Structure):
  pass
i32Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_int32))  ]

class i64Array(Structure):
  pass
i64Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_int64))  ]

class u8Array(Structure):
  pass
u8Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_uint8))  ]

class u16Array(Structure):
  pass
u16Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_uint16))  ]

class u32Array(Structure):
  pass
u32Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_uint32))  ]

class u64Array(Structure):
  pass
u64Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_uint64))  ]

class objectArray(Structure):
  pass
objectArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(POINTER(Object)))  ]
teTY_Invalid = 0
teTY_Intptr = 1
teTY_Uintptr = 2
teTY_Float = 3
teTY_Double = 4
teTY_U8 = 5
teTY_U16 = 6
teTY_U32 = 7
teTY_U64 = 8
teTY_I8 = 9
teTY_I16 = 10
teTY_I32 = 11
teTY_I64 = 12
teTY_Obj = 13
teTY_InternalPtr = 14
teTY_IfaceRef = 15
teTY_IfaceRefArray = 16
teTY_String = 17
teTY_Buffer = 18
teTY_Dict = 19
teTY_Vector = 20
teTY_List = 21



class Propref(Structure):
  pass
Propref._fields_ = [ 
    ('Typ', c_uint),
    ('Ptr', c_void_p)  ]


class PropName(Structure):
  pass
PropName._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Name', c_char_p)  ]

class Vector(Structure):
  pass
Vector._fields_ = [ 
    ('Typ', c_uint),
    ('VecData', c_void_p),
    ('Size', c_uint32),
    ('Capacity', c_uint32)  ]

class List(Structure):
  pass
List._fields_ = [ 
    ('Typ', c_uint),
    ('Head', c_void_p),
    ('Tail', c_void_p)  ]

class _U0(Union):
  pass
_U0._fields_ = [ 
    ('IntPtr', c_long),
    ('UIntPtr', c_ulong),
    ('f', c_float),
    ('d', c_double),
    ('u8', c_uint8),
    ('u16', c_uint16),
    ('u32', c_uint32),
    ('u64', c_uint64),
    ('i8', c_int8),
    ('i16', c_int16),
    ('i32', c_int32),
    ('i64', c_int64),
    ('Obj', POINTER(Object)),
    ('IfaceRef', IfaceRef),
    ('IfaceRefArray', IfaceRefArray),
    ('String', c_char_p),
    ('Buffer', Buff),
    ('Dict', c_void_p),
    ('Vector', Vector),
    ('List', List)  ]

class Propval(Structure):
  pass
Propval._anonymous_ = ('u0', )
Propval._fields_ = [ 
    ('Typ', c_uint),
    ('u0', _U0)  ]


class CreateArg(Structure):
  pass
CreateArg._fields_ = [ 
    ('Key', c_char_p),
    ('Val', Propval)  ]

ObjectCreateFunc = CFUNCTYPE(c_void_p, c_char_p, c_int, POINTER(CreateArg))

ObjectDisposeFunc = CFUNCTYPE(None, c_void_p)


class Class(Structure):
  pass
Class._fields_ = [ 
    ('Super', Object),
    ('Impl', c_void_p),
    ('VTable', c_void_p),
    ('Create', CFUNCTYPE(c_void_p, c_char_p, c_int, POINTER(CreateArg))),
    ('Dispose', CFUNCTYPE(None, c_void_p)),
    ('LoggingCategories', c_char_p * 32)  ]

dictCreate = TEMUSupport.temu_dictCreate
dictCreate.argtypes = []
dictCreate.restype = c_void_p

dictDispose = TEMUSupport.temu_dictDispose
dictDispose.argtypes = [c_void_p]
dictDispose.restype = None

dictInsertValue = TEMUSupport.temu_dictInsertValue
dictInsertValue.argtypes = [c_void_p, c_char_p, Propval]
dictInsertValue.restype = c_int

dictGetValue = TEMUSupport.temu_dictGetValue
dictGetValue.argtypes = [c_void_p, c_char_p]
dictGetValue.restype = Propval

dictRemoveValue = TEMUSupport.temu_dictRemoveValue
dictRemoveValue.argtypes = [c_void_p, c_char_p]
dictRemoveValue.restype = c_int

dictGetNextKey = TEMUSupport.temu_dictGetNextKey
dictGetNextKey.argtypes = [c_void_p, c_char_p]
dictGetNextKey.restype = c_char_p

vecCreate = TEMUSupport.temu_vecCreate
vecCreate.argtypes = [c_uint]
vecCreate.restype = Vector

vecDispose = TEMUSupport.temu_vecDispose
vecDispose.argtypes = [POINTER(Vector)]
vecDispose.restype = None

vecPush = TEMUSupport.temu_vecPush
vecPush.argtypes = [POINTER(Vector), Propval]
vecPush.restype = None

vecGetData = TEMUSupport.temu_vecGetData
vecGetData.argtypes = [POINTER(Vector)]
vecGetData.restype = c_void_p

vecGetSize = TEMUSupport.temu_vecGetSize
vecGetSize.argtypes = [POINTER(Vector)]
vecGetSize.restype = c_ulong

listCreate = TEMUSupport.temu_listCreate
listCreate.argtypes = [c_uint]
listCreate.restype = List

listDispose = TEMUSupport.temu_listDispose
listDispose.argtypes = [POINTER(List)]
listDispose.restype = None

listAppend = TEMUSupport.temu_listAppend
listAppend.argtypes = [POINTER(List), Propval]
listAppend.restype = None

listPrepend = TEMUSupport.temu_listPrepend
listPrepend.argtypes = [POINTER(List), Propval]
listPrepend.restype = None

listRemoveHead = TEMUSupport.temu_listRemoveHead
listRemoveHead.argtypes = [POINTER(List)]
listRemoveHead.restype = Propval

listRemoveTail = TEMUSupport.temu_listRemoveTail
listRemoveTail.argtypes = [POINTER(List)]
listRemoveTail.restype = Propval

listGetHead = TEMUSupport.temu_listGetHead
listGetHead.argtypes = [POINTER(List)]
listGetHead.restype = c_void_p

listGetTail = TEMUSupport.temu_listGetTail
listGetTail.argtypes = [POINTER(List)]
listGetTail.restype = c_void_p

listGetNext = TEMUSupport.temu_listGetNext
listGetNext.argtypes = [c_void_p]
listGetNext.restype = c_void_p

listGetPrev = TEMUSupport.temu_listGetPrev
listGetPrev.argtypes = [c_void_p]
listGetPrev.restype = c_void_p

listNodeGetVal = TEMUSupport.temu_listNodeGetVal
listNodeGetVal.argtypes = [c_void_p]
listNodeGetVal.restype = Propval

PropWriter = CFUNCTYPE(None, c_void_p, Propval, c_int)

PropReader = CFUNCTYPE(Propval, c_void_p, c_int)

getPropref = TEMUSupport.temu_getPropref
getPropref.argtypes = [POINTER(Object), c_char_p]
getPropref.restype = Propref


class PropAccessor(Structure):
  pass
PropAccessor._fields_ = [ 
    ('Typ', c_uint),
    ('Obj', POINTER(Object)),
    ('Index', c_int),
    ('Data', c_void_p),
    ('Writer', CFUNCTYPE(None, c_void_p, Propval, c_int)),
    ('Reader', CFUNCTYPE(Propval, c_void_p, c_int)),
    ('Setter', CFUNCTYPE(None, c_void_p, Propval, c_int)),
    ('Getter', CFUNCTYPE(Propval, c_void_p, c_int)),
    ('readProp', CFUNCTYPE(Propval, POINTER(PropAccessor))),
    ('writeProp', CFUNCTYPE(None, POINTER(PropAccessor), Propval)),
    ('getProp', CFUNCTYPE(Propval, POINTER(PropAccessor))),
    ('setProp', CFUNCTYPE(None, POINTER(PropAccessor), Propval))  ]

getPropAccessor = TEMUSupport.temu_getPropAccessor
getPropAccessor.argtypes = [POINTER(Object), c_char_p, c_int]
getPropAccessor.restype = PropAccessor

getPropName = TEMUSupport.temu_getPropName
getPropName.argtypes = [POINTER(Object), c_char_p]
getPropName.restype = PropName

getPropLength = TEMUSupport.temu_getPropLength
getPropLength.argtypes = [POINTER(Object), c_char_p]
getPropLength.restype = c_int

getPropDynLength = TEMUSupport.temu_getPropDynLength
getPropDynLength.argtypes = [POINTER(Object), c_char_p]
getPropDynLength.restype = c_int

getPropType = TEMUSupport.temu_getPropType
getPropType.argtypes = [POINTER(Object), c_char_p]
getPropType.restype = c_uint

objectHasProp = TEMUSupport.temu_objectHasProp
objectHasProp.argtypes = [POINTER(Object), c_char_p]
objectHasProp.restype = c_int

objectHasIface = TEMUSupport.temu_objectHasIface
objectHasIface.argtypes = [POINTER(Object), c_char_p]
objectHasIface.restype = c_int

isNumber = TEMUSupport.temu_isNumber
isNumber.argtypes = [Propval]
isNumber.restype = c_int

isReal = TEMUSupport.temu_isReal
isReal.argtypes = [Propval]
isReal.restype = c_int

isDiscrete = TEMUSupport.temu_isDiscrete
isDiscrete.argtypes = [Propval]
isDiscrete.restype = c_int

isUnsigned = TEMUSupport.temu_isUnsigned
isUnsigned.argtypes = [Propval]
isUnsigned.restype = c_int

isSigned = TEMUSupport.temu_isSigned
isSigned.argtypes = [Propval]
isSigned.restype = c_int

isString = TEMUSupport.temu_isString
isString.argtypes = [Propval]
isString.restype = c_int

asInteger = TEMUSupport.temu_asInteger
asInteger.argtypes = [Propval]
asInteger.restype = c_int64

asUnsigned = TEMUSupport.temu_asUnsigned
asUnsigned.argtypes = [Propval]
asUnsigned.restype = c_uint64

asDouble = TEMUSupport.temu_asDouble
asDouble.argtypes = [Propval]
asDouble.restype = c_double

getValueU8 = TEMUSupport.temu_getValueU8
getValueU8.argtypes = [POINTER(Object), c_char_p, c_int]
getValueU8.restype = c_uint8

getValueU16 = TEMUSupport.temu_getValueU16
getValueU16.argtypes = [POINTER(Object), c_char_p, c_int]
getValueU16.restype = c_uint16

getValueU32 = TEMUSupport.temu_getValueU32
getValueU32.argtypes = [POINTER(Object), c_char_p, c_int]
getValueU32.restype = c_uint32

getValueU64 = TEMUSupport.temu_getValueU64
getValueU64.argtypes = [POINTER(Object), c_char_p, c_int]
getValueU64.restype = c_uint64

getValueI8 = TEMUSupport.temu_getValueI8
getValueI8.argtypes = [POINTER(Object), c_char_p, c_int]
getValueI8.restype = c_int8

getValueI16 = TEMUSupport.temu_getValueI16
getValueI16.argtypes = [POINTER(Object), c_char_p, c_int]
getValueI16.restype = c_int16

getValueI32 = TEMUSupport.temu_getValueI32
getValueI32.argtypes = [POINTER(Object), c_char_p, c_int]
getValueI32.restype = c_int32

getValueI64 = TEMUSupport.temu_getValueI64
getValueI64.argtypes = [POINTER(Object), c_char_p, c_int]
getValueI64.restype = c_int64

readValueU8 = TEMUSupport.temu_readValueU8
readValueU8.argtypes = [POINTER(Object), c_char_p, c_int]
readValueU8.restype = c_uint8

readValueU16 = TEMUSupport.temu_readValueU16
readValueU16.argtypes = [POINTER(Object), c_char_p, c_int]
readValueU16.restype = c_uint16

readValueU32 = TEMUSupport.temu_readValueU32
readValueU32.argtypes = [POINTER(Object), c_char_p, c_int]
readValueU32.restype = c_uint32

readValueU64 = TEMUSupport.temu_readValueU64
readValueU64.argtypes = [POINTER(Object), c_char_p, c_int]
readValueU64.restype = c_uint64

readValueI8 = TEMUSupport.temu_readValueI8
readValueI8.argtypes = [POINTER(Object), c_char_p, c_int]
readValueI8.restype = c_int8

readValueI16 = TEMUSupport.temu_readValueI16
readValueI16.argtypes = [POINTER(Object), c_char_p, c_int]
readValueI16.restype = c_int16

readValueI32 = TEMUSupport.temu_readValueI32
readValueI32.argtypes = [POINTER(Object), c_char_p, c_int]
readValueI32.restype = c_int32

readValueI64 = TEMUSupport.temu_readValueI64
readValueI64.argtypes = [POINTER(Object), c_char_p, c_int]
readValueI64.restype = c_int64

setValueU8 = TEMUSupport.temu_setValueU8
setValueU8.argtypes = [POINTER(Object), c_char_p, c_uint8, c_int]
setValueU8.restype = None

setValueU16 = TEMUSupport.temu_setValueU16
setValueU16.argtypes = [POINTER(Object), c_char_p, c_uint16, c_int]
setValueU16.restype = None

setValueU32 = TEMUSupport.temu_setValueU32
setValueU32.argtypes = [POINTER(Object), c_char_p, c_uint32, c_int]
setValueU32.restype = None

setValueU64 = TEMUSupport.temu_setValueU64
setValueU64.argtypes = [POINTER(Object), c_char_p, c_uint64, c_int]
setValueU64.restype = None

setValueI8 = TEMUSupport.temu_setValueI8
setValueI8.argtypes = [POINTER(Object), c_char_p, c_int8, c_int]
setValueI8.restype = None

setValueI16 = TEMUSupport.temu_setValueI16
setValueI16.argtypes = [POINTER(Object), c_char_p, c_int16, c_int]
setValueI16.restype = None

setValueI32 = TEMUSupport.temu_setValueI32
setValueI32.argtypes = [POINTER(Object), c_char_p, c_int32, c_int]
setValueI32.restype = None

setValueI64 = TEMUSupport.temu_setValueI64
setValueI64.argtypes = [POINTER(Object), c_char_p, c_int64, c_int]
setValueI64.restype = None

writeValueU8 = TEMUSupport.temu_writeValueU8
writeValueU8.argtypes = [POINTER(Object), c_char_p, c_uint8, c_int]
writeValueU8.restype = None

writeValueU16 = TEMUSupport.temu_writeValueU16
writeValueU16.argtypes = [POINTER(Object), c_char_p, c_uint16, c_int]
writeValueU16.restype = None

writeValueU32 = TEMUSupport.temu_writeValueU32
writeValueU32.argtypes = [POINTER(Object), c_char_p, c_uint32, c_int]
writeValueU32.restype = None

writeValueU64 = TEMUSupport.temu_writeValueU64
writeValueU64.argtypes = [POINTER(Object), c_char_p, c_uint64, c_int]
writeValueU64.restype = None

writeValueI8 = TEMUSupport.temu_writeValueI8
writeValueI8.argtypes = [POINTER(Object), c_char_p, c_int8, c_int]
writeValueI8.restype = None

writeValueI16 = TEMUSupport.temu_writeValueI16
writeValueI16.argtypes = [POINTER(Object), c_char_p, c_int16, c_int]
writeValueI16.restype = None

writeValueI32 = TEMUSupport.temu_writeValueI32
writeValueI32.argtypes = [POINTER(Object), c_char_p, c_int32, c_int]
writeValueI32.restype = None

writeValueI64 = TEMUSupport.temu_writeValueI64
writeValueI64.argtypes = [POINTER(Object), c_char_p, c_int64, c_int]
writeValueI64.restype = None

writeValueObj = TEMUSupport.temu_writeValueObj
writeValueObj.argtypes = [POINTER(Object), c_char_p, POINTER(Object), c_int]
writeValueObj.restype = None

registerClass = TEMUSupport.temu_registerClass
registerClass.argtypes = [c_char_p, CFUNCTYPE(c_void_p, c_char_p, c_int, POINTER(CreateArg)), CFUNCTYPE(None, c_void_p)]
registerClass.restype = POINTER(Class)

addProperty = TEMUSupport.temu_addProperty
addProperty.argtypes = [POINTER(Class), c_char_p, c_int, c_uint, c_int, CFUNCTYPE(None, c_void_p, Propval, c_int), CFUNCTYPE(Propval, c_void_p, c_int), c_char_p]
addProperty.restype = None

addPseudoProperty = TEMUSupport.temu_addPseudoProperty
addPseudoProperty.argtypes = [POINTER(Class), c_char_p, c_uint, c_int, CFUNCTYPE(None, c_void_p, Propval, c_int), CFUNCTYPE(Propval, c_void_p, c_int), CFUNCTYPE(None, c_void_p, Propval, c_int), CFUNCTYPE(Propval, c_void_p, c_int), c_char_p]
addPseudoProperty.restype = None

addLoggingCategory = TEMUSupport.temu_addLoggingCategory
addLoggingCategory.argtypes = [POINTER(Class), c_uint, c_char_p]
addLoggingCategory.restype = c_int

getLoggingCategory = TEMUSupport.temu_getLoggingCategory
getLoggingCategory.argtypes = [POINTER(Class), c_uint]
getLoggingCategory.restype = c_char_p

isPseudoProperty = TEMUSupport.temu_isPseudoProperty
isPseudoProperty.argtypes = [POINTER(Object), c_char_p]
isPseudoProperty.restype = c_int

isNormalProperty = TEMUSupport.temu_isNormalProperty
isNormalProperty.argtypes = [POINTER(Object), c_char_p]
isNormalProperty.restype = c_int

requireInterface = TEMUSupport.temu_requireInterface
requireInterface.argtypes = [POINTER(Class), c_char_p, c_char_p]
requireInterface.restype = None

addInterfaceReference = TEMUSupport.temu_addInterfaceReference
addInterfaceReference.argtypes = [POINTER(Class), c_char_p, c_int, c_char_p, c_int, c_uint, CFUNCTYPE(None, c_void_p, Propval, c_int), CFUNCTYPE(Propval, c_void_p, c_int), c_char_p]
addInterfaceReference.restype = None

addPseudoInterfaceReference = TEMUSupport.temu_addPseudoInterfaceReference
addPseudoInterfaceReference.argtypes = [POINTER(Class), c_char_p, c_char_p, c_int, c_uint, CFUNCTYPE(None, c_void_p, Propval, c_int), CFUNCTYPE(Propval, c_void_p, c_int), CFUNCTYPE(None, c_void_p, Propval, c_int), CFUNCTYPE(Propval, c_void_p, c_int), c_char_p]
addPseudoInterfaceReference.restype = None

addPort = TEMUSupport.temu_addPort
addPort.argtypes = [POINTER(Class), c_char_p, c_char_p, c_char_p]
addPort.restype = c_int

addInterface = TEMUSupport.temu_addInterface
addInterface.argtypes = [POINTER(Class), c_char_p, c_char_p, c_void_p, c_int, c_char_p]
addInterface.restype = None

getInterface = TEMUSupport.temu_getInterface
getInterface.argtypes = [POINTER(Object), c_char_p, c_int]
getInterface.restype = c_void_p

getInterfaceRef = TEMUSupport.temu_getInterfaceRef
getInterfaceRef.argtypes = [POINTER(Object), c_char_p, c_int]
getInterfaceRef.restype = IfaceRef

getInterfaceName = TEMUSupport.temu_getInterfaceName
getInterfaceName.argtypes = [POINTER(Object), c_void_p]
getInterfaceName.restype = c_char_p

addInterfaceArray = TEMUSupport.temu_addInterfaceArray
addInterfaceArray.argtypes = [POINTER(Class), c_char_p, c_char_p, c_void_p, c_ulong, c_ulong, c_char_p]
addInterfaceArray.restype = None

setVTable = TEMUSupport.temu_setVTable
setVTable.argtypes = [POINTER(Class), c_void_p]
setVTable.restype = c_int

getVTableForClass = TEMUSupport.temu_getVTableForClass
getVTableForClass.argtypes = [POINTER(Class)]
getVTableForClass.restype = c_void_p

getVTable = TEMUSupport.temu_getVTable
getVTable.argtypes = [POINTER(Object)]
getVTable.restype = c_void_p

setTimeSource = TEMUSupport.temu_setTimeSource
setTimeSource.argtypes = [POINTER(Object), POINTER(TimeSource)]
setTimeSource.restype = None

isQualifiedAs = TEMUSupport.temu_isQualifiedAs
isQualifiedAs.argtypes = [POINTER(Object), c_uint]
isQualifiedAs.restype = c_int

isCpu = TEMUSupport.temu_isCpu
isCpu.argtypes = [POINTER(Object)]
isCpu.restype = c_int

isMachine = TEMUSupport.temu_isMachine
isMachine.argtypes = [POINTER(Object)]
isMachine.restype = c_int

isMemory = TEMUSupport.temu_isMemory
isMemory.argtypes = [POINTER(Object)]
isMemory.restype = c_int

isComponent = TEMUSupport.temu_isComponent
isComponent.argtypes = [POINTER(Object)]
isComponent.restype = c_int

qualifyAsCpu = TEMUSupport.temu_qualifyAsCpu
qualifyAsCpu.argtypes = [POINTER(Class)]
qualifyAsCpu.restype = None

qualifyAsMachine = TEMUSupport.temu_qualifyAsMachine
qualifyAsMachine.argtypes = [POINTER(Class)]
qualifyAsMachine.restype = None

qualifyAsMemory = TEMUSupport.temu_qualifyAsMemory
qualifyAsMemory.argtypes = [POINTER(Class)]
qualifyAsMemory.restype = None

qualifyAs = TEMUSupport.temu_qualifyAs
qualifyAs.argtypes = [POINTER(Class), c_uint]
qualifyAs.restype = None

objsysClear = TEMUSupport.temu_objsysClear
objsysClear.argtypes = []
objsysClear.restype = None

objsysClearObjects = TEMUSupport.temu_objsysClearObjects
objsysClearObjects.argtypes = []
objsysClearObjects.restype = None

createObject = TEMUSupport.temu_createObject
createObject.argtypes = [c_char_p, c_char_p, POINTER(CreateArg)]
createObject.restype = POINTER(Object)

disposeObject = TEMUSupport.temu_disposeObject
disposeObject.argtypes = [POINTER(Object)]
disposeObject.restype = None

classForName = TEMUSupport.temu_classForName
classForName.argtypes = [c_char_p]
classForName.restype = POINTER(Class)

nameForClass = TEMUSupport.temu_nameForClass
nameForClass.argtypes = [POINTER(Class)]
nameForClass.restype = c_char_p

classForObject = TEMUSupport.temu_classForObject
classForObject.argtypes = [POINTER(Object)]
classForObject.restype = POINTER(Class)

classHasCommand = TEMUSupport.temu_classHasCommand
classHasCommand.argtypes = [POINTER(Class), c_char_p]
classHasCommand.restype = c_int


class PropInfo(Structure):
  pass
PropInfo._fields_ = [ 
    ('Name', c_char_p),
    ('Typ', c_uint),
    ('Count', c_ulong),
    ('Offset', c_ulong),
    ('TypeObj', c_void_p)  ]
propInfoForClass = TEMUSupport.temu_propInfoForClass
propInfoForClass.argtypes = [POINTER(Class), c_uint, c_uint, POINTER(PropInfo)]
propInfoForClass.restype = c_int

objectForName = TEMUSupport.temu_objectForName
objectForName.argtypes = [c_char_p]
objectForName.restype = POINTER(Object)

nameForObject = TEMUSupport.temu_nameForObject
nameForObject.argtypes = [POINTER(Object)]
nameForObject.restype = c_char_p

nameForInterface = TEMUSupport.temu_nameForInterface
nameForInterface.argtypes = [POINTER(Object), c_void_p]
nameForInterface.restype = c_char_p

indexForInterface = TEMUSupport.temu_indexForInterface
indexForInterface.argtypes = [POINTER(Object), c_void_p]
indexForInterface.restype = c_int

typenameForInterface = TEMUSupport.temu_typenameForInterface
typenameForInterface.argtypes = [POINTER(Object), c_void_p]
typenameForInterface.restype = c_char_p

loadPlugin = TEMUSupport.temu_loadPlugin
loadPlugin.argtypes = [c_char_p]
loadPlugin.restype = c_int

loadPluginGlobal = TEMUSupport.temu_loadPluginGlobal
loadPluginGlobal.argtypes = [c_char_p]
loadPluginGlobal.restype = c_int

pluginPathAppend = TEMUSupport.temu_pluginPathAppend
pluginPathAppend.argtypes = [c_char_p]
pluginPathAppend.restype = None

pluginPathRemove = TEMUSupport.temu_pluginPathRemove
pluginPathRemove.argtypes = [c_char_p]
pluginPathRemove.restype = None

pluginPathPrint = TEMUSupport.temu_pluginPathPrint
pluginPathPrint.argtypes = []
pluginPathPrint.restype = None

typeToName = TEMUSupport.temu_typeToName
typeToName.argtypes = [c_uint]
typeToName.restype = c_char_p

getProcessors = TEMUSupport.temu_getProcessors
getProcessors.argtypes = []
getProcessors.restype = POINTER(POINTER(Object))

getProcessorCount = TEMUSupport.temu_getProcessorCount
getProcessorCount.argtypes = []
getProcessorCount.restype = c_ulong

getComponents = TEMUSupport.temu_getComponents
getComponents.argtypes = []
getComponents.restype = POINTER(POINTER(Component))

getComponentCount = TEMUSupport.temu_getComponentCount
getComponentCount.argtypes = []
getComponentCount.restype = c_ulong

connect = TEMUSupport.temu_connect
connect.argtypes = [POINTER(Object), c_char_p, POINTER(Object), c_char_p]
connect.restype = c_int

serialiseJSON = TEMUSupport.temu_serialiseJSON
serialiseJSON.argtypes = [c_char_p]
serialiseJSON.restype = c_int

deserialiseJSON = TEMUSupport.temu_deserialiseJSON
deserialiseJSON.argtypes = [c_char_p]
deserialiseJSON.restype = c_int

inlineDeserialiseJSON = TEMUSupport.temu_inlineDeserialiseJSON
inlineDeserialiseJSON.argtypes = [c_char_p]
inlineDeserialiseJSON.restype = c_int

serialiseProp = TEMUSupport.temu_serialiseProp
serialiseProp.argtypes = [c_void_p, c_char_p, c_uint, c_int, c_void_p]
serialiseProp.restype = None

deserialiseProp = TEMUSupport.temu_deserialiseProp
deserialiseProp.argtypes = [c_void_p, POINTER(Object), c_char_p]
deserialiseProp.restype = None

snapshotGetLength = TEMUSupport.temu_snapshotGetLength
snapshotGetLength.argtypes = [c_void_p, c_char_p]
snapshotGetLength.restype = c_int

checkpointGetLength = TEMUSupport.temu_checkpointGetLength
checkpointGetLength.argtypes = [c_void_p, c_char_p]
checkpointGetLength.restype = c_int

snapshotGetValue = TEMUSupport.temu_snapshotGetValue
snapshotGetValue.argtypes = [c_void_p, c_char_p, c_int]
snapshotGetValue.restype = Propval

checkpointGetValue = TEMUSupport.temu_checkpointGetValue
checkpointGetValue.argtypes = [c_void_p, c_char_p, c_int]
checkpointGetValue.restype = Propval

checkSanity = TEMUSupport.temu_checkSanity
checkSanity.argtypes = [c_int]
checkSanity.restype = c_int

generateObjectGraph = TEMUSupport.temu_generateObjectGraph
generateObjectGraph.argtypes = [c_char_p, c_int]
generateObjectGraph.restype = c_int

isValidObjectName = TEMUSupport.temu_isValidObjectName
isValidObjectName.argtypes = [c_char_p]
isValidObjectName.restype = c_int

isValidClassName = TEMUSupport.temu_isValidClassName
isValidClassName.argtypes = [c_char_p]
isValidClassName.restype = c_int

isValidInterfaceName = TEMUSupport.temu_isValidInterfaceName
isValidInterfaceName.argtypes = [c_char_p]
isValidInterfaceName.restype = c_int

isValidPropertyName = TEMUSupport.temu_isValidPropertyName
isValidPropertyName.argtypes = [c_char_p]
isValidPropertyName.restype = c_int


class ObjectIface(Structure):
  pass
ObjectIface._fields_ = [ 
    ('serialise', CFUNCTYPE(None, c_void_p, c_char_p, c_void_p)),
    ('deserialise', CFUNCTYPE(None, c_void_p, c_char_p, c_void_p)),
    ('checkSanity', CFUNCTYPE(c_int, c_void_p, c_int)),
    ('timeSourceSet', CFUNCTYPE(None, c_void_p)),
    ('printObject', CFUNCTYPE(None, c_void_p))  ]

class ObjectIfaceRef(Structure):
  pass
ObjectIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(ObjectIface))  ]

class ObjectIfaceRefArray(Structure):
  pass
ObjectIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(ObjectIfaceRef))  ]
foreachObject = TEMUSupport.temu_foreachObject
foreachObject.argtypes = [CFUNCTYPE(None, POINTER(Object), c_void_p), c_void_p]
foreachObject.restype = None

foreachClass = TEMUSupport.temu_foreachClass
foreachClass.argtypes = [CFUNCTYPE(None, POINTER(Class), c_void_p), c_void_p]
foreachClass.restype = None

foreachProcessor = TEMUSupport.temu_foreachProcessor
foreachProcessor.argtypes = [CFUNCTYPE(None, POINTER(Object), c_void_p), c_void_p]
foreachProcessor.restype = None

foreachProperty = TEMUSupport.temu_foreachProperty
foreachProperty.argtypes = [POINTER(Class), CFUNCTYPE(None, POINTER(Class), c_char_p, c_void_p), c_void_p]
foreachProperty.restype = None

foreachInterface = TEMUSupport.temu_foreachInterface
foreachInterface.argtypes = [POINTER(Class), CFUNCTYPE(None, POINTER(Class), c_char_p, c_void_p), c_void_p]
foreachInterface.restype = None

registerInterfaceType = TEMUSupport.temu_registerInterfaceType
registerInterfaceType.argtypes = [c_char_p]
registerInterfaceType.restype = c_void_p

getInterfaceType = TEMUSupport.temu_getInterfaceType
getInterfaceType.argtypes = [c_char_p]
getInterfaceType.restype = c_void_p

addScalarProperty = TEMUSupport.temu_addScalarProperty
addScalarProperty.argtypes = [POINTER(Class), c_char_p, c_int, c_uint, c_char_p]
addScalarProperty.restype = c_int

addArrayProperty = TEMUSupport.temu_addArrayProperty
addArrayProperty.argtypes = [POINTER(Class), c_char_p, c_int, c_uint, c_int, c_char_p]
addArrayProperty.restype = c_int

addScalarPseudoProperty = TEMUSupport.temu_addScalarPseudoProperty
addScalarPseudoProperty.argtypes = [POINTER(Class), c_char_p, c_uint, c_char_p]
addScalarPseudoProperty.restype = c_int

addArrayPseudoProperty = TEMUSupport.temu_addArrayPseudoProperty
addArrayPseudoProperty.argtypes = [POINTER(Class), c_char_p, c_uint, c_int, c_char_p]
addArrayPseudoProperty.restype = c_int

writeProp = TEMUSupport.temu_writeProp
writeProp.argtypes = [POINTER(Object), c_char_p, c_int, POINTER(Propval)]
writeProp.restype = c_int

readProp = TEMUSupport.temu_readProp
readProp.argtypes = [POINTER(Object), c_char_p, c_int]
readProp.restype = Propval

getValueUnsigned = TEMUSupport.temu_getValueUnsigned
getValueUnsigned.argtypes = [POINTER(Object), c_char_p, c_int]
getValueUnsigned.restype = c_uint64

getValueSigned = TEMUSupport.temu_getValueSigned
getValueSigned.argtypes = [POINTER(Object), c_char_p, c_int]
getValueSigned.restype = c_int64

getValueDouble = TEMUSupport.temu_getValueDouble
getValueDouble.argtypes = [POINTER(Object), c_char_p, c_int]
getValueDouble.restype = c_double

readValueUnsigned = TEMUSupport.temu_readValueUnsigned
readValueUnsigned.argtypes = [POINTER(Object), c_char_p, c_int]
readValueUnsigned.restype = c_uint64

readValueSigned = TEMUSupport.temu_readValueSigned
readValueSigned.argtypes = [POINTER(Object), c_char_p, c_int]
readValueSigned.restype = c_int64

readValueDouble = TEMUSupport.temu_readValueDouble
readValueDouble.argtypes = [POINTER(Object), c_char_p, c_int]
readValueDouble.restype = c_double

setValueUnsigned = TEMUSupport.temu_setValueUnsigned
setValueUnsigned.argtypes = [POINTER(Object), c_char_p, c_uint64, c_int]
setValueUnsigned.restype = None

setValueSigned = TEMUSupport.temu_setValueSigned
setValueSigned.argtypes = [POINTER(Object), c_char_p, c_int64, c_int]
setValueSigned.restype = None

setValueDouble = TEMUSupport.temu_setValueDouble
setValueDouble.argtypes = [POINTER(Object), c_char_p, c_double, c_int]
setValueDouble.restype = None

writeValueUnsigned = TEMUSupport.temu_writeValueUnsigned
writeValueUnsigned.argtypes = [POINTER(Object), c_char_p, c_uint64, c_int]
writeValueUnsigned.restype = None

writeValueSigned = TEMUSupport.temu_writeValueSigned
writeValueSigned.argtypes = [POINTER(Object), c_char_p, c_int64, c_int]
writeValueSigned.restype = None

writeValueDouble = TEMUSupport.temu_writeValueDouble
writeValueDouble.argtypes = [POINTER(Object), c_char_p, c_double, c_int]
writeValueDouble.restype = None

signedPropval = TEMUSupport.temu_signedPropval
signedPropval.argtypes = [c_uint, c_int64]
signedPropval.restype = Propval

unsignedPropval = TEMUSupport.temu_unsignedPropval
unsignedPropval.argtypes = [c_uint, c_uint64]
unsignedPropval.restype = Propval

floatingPointPropval = TEMUSupport.temu_floatingPointPropval
floatingPointPropval.argtypes = [c_uint, c_double]
floatingPointPropval.restype = Propval

objectHasCmd = TEMUSupport.temu_objectHasCmd
objectHasCmd.argtypes = [POINTER(Object), c_char_p]
objectHasCmd.restype = c_int

from ctypes import *
TEMUSupport = CDLL('libTEMUSupport.so.4')


class Buff(Structure):
  pass
Buff._fields_ = [ 
    ('data0', c_ulong),
    ('data1', c_uint32),
    ('data2', c_uint32)  ]

class Component(Structure):
  pass
Component._fields_ = [  ]


class Class(Structure):
  pass
Class._fields_ = [  ]


class TimeSource(Structure):
  pass
TimeSource._fields_ = [  ]


class Object(Structure):
  pass
Object._fields_ = [ 
    ('Class', POINTER(Class)),
    ('Name', c_char_p),
    ('TimeSource', POINTER(TimeSource)),
    ('Component', POINTER(Component)),
    ('LoggingFlags', c_uint64),
    ('WillDisposeNotification', c_int64),
    ('DisposedNotification', c_int64),
    ('UserData', c_void_p),
    ('IsClassObject', c_uint64),
    ('IsCheckpointable', c_uint64),
    ('IsTimeSource', c_uint64),
    ('TraceMemoryReads', c_uint64),
    ('TraceMemoryWrites', c_uint64),
    ('BreakOnMemoryRead', c_uint64),
    ('BreakOnMemoryWrite', c_uint64)  ]


class IfaceRef(Structure):
  pass
IfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', c_void_p)  ]


class IfaceRefArray(Structure):
  pass
IfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(IfaceRef))  ]

ifaceRefArrayAlloc = TEMUSupport.temu_ifaceRefArrayAlloc
ifaceRefArrayAlloc.argtypes = [c_uint]
ifaceRefArrayAlloc.restype = IfaceRefArray

ifaceRefArrayPush2 = TEMUSupport.temu_ifaceRefArrayPush2
ifaceRefArrayPush2.argtypes = [POINTER(IfaceRefArray), POINTER(Object), c_void_p]
ifaceRefArrayPush2.restype = None

ifaceRefArrayPush = TEMUSupport.temu_ifaceRefArrayPush
ifaceRefArrayPush.argtypes = [POINTER(IfaceRefArray), IfaceRef]
ifaceRefArrayPush.restype = None

ifaceRefArraySize = TEMUSupport.temu_ifaceRefArraySize
ifaceRefArraySize.argtypes = [POINTER(IfaceRefArray)]
ifaceRefArraySize.restype = c_uint

ifaceRefArrayGet = TEMUSupport.temu_ifaceRefArrayGet
ifaceRefArrayGet.argtypes = [POINTER(IfaceRefArray), c_uint]
ifaceRefArrayGet.restype = IfaceRef

ifaceRefArrayDispose = TEMUSupport.temu_ifaceRefArrayDispose
ifaceRefArrayDispose.argtypes = [POINTER(IfaceRefArray)]
ifaceRefArrayDispose.restype = None


class i8Array(Structure):
  pass
i8Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_int8))  ]

class i16Array(Structure):
  pass
i16Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_int16))  ]

class i32Array(Structure):
  pass
i32Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_int32))  ]

class i64Array(Structure):
  pass
i64Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_int64))  ]

class u8Array(Structure):
  pass
u8Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_uint8))  ]

class u16Array(Structure):
  pass
u16Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_uint16))  ]

class u32Array(Structure):
  pass
u32Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_uint32))  ]

class u64Array(Structure):
  pass
u64Array._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(c_uint64))  ]

class objectArray(Structure):
  pass
objectArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Values', POINTER(POINTER(Object)))  ]
teTY_Invalid = 0
teTY_Intptr = 1
teTY_Uintptr = 2
teTY_Float = 3
teTY_Double = 4
teTY_U8 = 5
teTY_U16 = 6
teTY_U32 = 7
teTY_U64 = 8
teTY_I8 = 9
teTY_I16 = 10
teTY_I32 = 11
teTY_I64 = 12
teTY_Obj = 13
teTY_InternalPtr = 14
teTY_IfaceRef = 15
teTY_IfaceRefArray = 16
teTY_String = 17
teTY_Buffer = 18
teTY_Dict = 19
teTY_Vector = 20
teTY_List = 21



class Propref(Structure):
  pass
Propref._fields_ = [ 
    ('Typ', c_uint),
    ('Ptr', c_void_p)  ]


class PropName(Structure):
  pass
PropName._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Name', c_char_p)  ]

class Vector(Structure):
  pass
Vector._fields_ = [ 
    ('Typ', c_uint),
    ('VecData', c_void_p),
    ('Size', c_uint32),
    ('Capacity', c_uint32)  ]

class List(Structure):
  pass
List._fields_ = [ 
    ('Typ', c_uint),
    ('Head', c_void_p),
    ('Tail', c_void_p)  ]

class _U0(Union):
  pass
_U0._fields_ = [ 
    ('IntPtr', c_long),
    ('UIntPtr', c_ulong),
    ('f', c_float),
    ('d', c_double),
    ('u8', c_uint8),
    ('u16', c_uint16),
    ('u32', c_uint32),
    ('u64', c_uint64),
    ('i8', c_int8),
    ('i16', c_int16),
    ('i32', c_int32),
    ('i64', c_int64),
    ('Obj', POINTER(Object)),
    ('IfaceRef', IfaceRef),
    ('IfaceRefArray', IfaceRefArray),
    ('String', c_char_p),
    ('Buffer', Buff),
    ('Dict', c_void_p),
    ('Vector', Vector),
    ('List', List)  ]

class Propval(Structure):
  pass
Propval._anonymous_ = ('u0', )
Propval._fields_ = [ 
    ('Typ', c_uint),
    ('u0', _U0)  ]


class CreateArg(Structure):
  pass
CreateArg._fields_ = [ 
    ('Key', c_char_p),
    ('Val', Propval)  ]

ObjectCreateFunc = CFUNCTYPE(c_void_p, c_char_p, c_int, POINTER(CreateArg))

ObjectDisposeFunc = CFUNCTYPE(None, c_void_p)


class Class(Structure):
  pass
Class._fields_ = [ 
    ('Super', Object),
    ('Impl', c_void_p),
    ('VTable', c_void_p),
    ('Create', CFUNCTYPE(c_void_p, c_char_p, c_int, POINTER(CreateArg))),
    ('Dispose', CFUNCTYPE(None, c_void_p)),
    ('LoggingCategories', c_char_p * 32)  ]

dictCreate = TEMUSupport.temu_dictCreate
dictCreate.argtypes = []
dictCreate.restype = c_void_p

dictDispose = TEMUSupport.temu_dictDispose
dictDispose.argtypes = [c_void_p]
dictDispose.restype = None

dictInsertValue = TEMUSupport.temu_dictInsertValue
dictInsertValue.argtypes = [c_void_p, c_char_p, Propval]
dictInsertValue.restype = c_int

dictGetValue = TEMUSupport.temu_dictGetValue
dictGetValue.argtypes = [c_void_p, c_char_p]
dictGetValue.restype = Propval

dictRemoveValue = TEMUSupport.temu_dictRemoveValue
dictRemoveValue.argtypes = [c_void_p, c_char_p]
dictRemoveValue.restype = c_int

dictGetNextKey = TEMUSupport.temu_dictGetNextKey
dictGetNextKey.argtypes = [c_void_p, c_char_p]
dictGetNextKey.restype = c_char_p

vecCreate = TEMUSupport.temu_vecCreate
vecCreate.argtypes = [c_uint]
vecCreate.restype = Vector

vecDispose = TEMUSupport.temu_vecDispose
vecDispose.argtypes = [POINTER(Vector)]
vecDispose.restype = None

vecPush = TEMUSupport.temu_vecPush
vecPush.argtypes = [POINTER(Vector), Propval]
vecPush.restype = None

vecGetData = TEMUSupport.temu_vecGetData
vecGetData.argtypes = [POINTER(Vector)]
vecGetData.restype = c_void_p

vecGetSize = TEMUSupport.temu_vecGetSize
vecGetSize.argtypes = [POINTER(Vector)]
vecGetSize.restype = c_ulong

listCreate = TEMUSupport.temu_listCreate
listCreate.argtypes = [c_uint]
listCreate.restype = List

listDispose = TEMUSupport.temu_listDispose
listDispose.argtypes = [POINTER(List)]
listDispose.restype = None

listAppend = TEMUSupport.temu_listAppend
listAppend.argtypes = [POINTER(List), Propval]
listAppend.restype = None

listPrepend = TEMUSupport.temu_listPrepend
listPrepend.argtypes = [POINTER(List), Propval]
listPrepend.restype = None

listRemoveHead = TEMUSupport.temu_listRemoveHead
listRemoveHead.argtypes = [POINTER(List)]
listRemoveHead.restype = Propval

listRemoveTail = TEMUSupport.temu_listRemoveTail
listRemoveTail.argtypes = [POINTER(List)]
listRemoveTail.restype = Propval

listGetHead = TEMUSupport.temu_listGetHead
listGetHead.argtypes = [POINTER(List)]
listGetHead.restype = c_void_p

listGetTail = TEMUSupport.temu_listGetTail
listGetTail.argtypes = [POINTER(List)]
listGetTail.restype = c_void_p

listGetNext = TEMUSupport.temu_listGetNext
listGetNext.argtypes = [c_void_p]
listGetNext.restype = c_void_p

listGetPrev = TEMUSupport.temu_listGetPrev
listGetPrev.argtypes = [c_void_p]
listGetPrev.restype = c_void_p

listNodeGetVal = TEMUSupport.temu_listNodeGetVal
listNodeGetVal.argtypes = [c_void_p]
listNodeGetVal.restype = Propval

PropWriter = CFUNCTYPE(None, c_void_p, Propval, c_int)

PropReader = CFUNCTYPE(Propval, c_void_p, c_int)

getPropref = TEMUSupport.temu_getPropref
getPropref.argtypes = [POINTER(Object), c_char_p]
getPropref.restype = Propref


class PropAccessor(Structure):
  pass
PropAccessor._fields_ = [ 
    ('Typ', c_uint),
    ('Obj', POINTER(Object)),
    ('Index', c_int),
    ('Data', c_void_p),
    ('Writer', CFUNCTYPE(None, c_void_p, Propval, c_int)),
    ('Reader', CFUNCTYPE(Propval, c_void_p, c_int)),
    ('Setter', CFUNCTYPE(None, c_void_p, Propval, c_int)),
    ('Getter', CFUNCTYPE(Propval, c_void_p, c_int)),
    ('readProp', CFUNCTYPE(Propval, POINTER(PropAccessor))),
    ('writeProp', CFUNCTYPE(None, POINTER(PropAccessor), Propval)),
    ('getProp', CFUNCTYPE(Propval, POINTER(PropAccessor))),
    ('setProp', CFUNCTYPE(None, POINTER(PropAccessor), Propval))  ]

getPropAccessor = TEMUSupport.temu_getPropAccessor
getPropAccessor.argtypes = [POINTER(Object), c_char_p, c_int]
getPropAccessor.restype = PropAccessor

getPropName = TEMUSupport.temu_getPropName
getPropName.argtypes = [POINTER(Object), c_char_p]
getPropName.restype = PropName

getPropLength = TEMUSupport.temu_getPropLength
getPropLength.argtypes = [POINTER(Object), c_char_p]
getPropLength.restype = c_int

getPropDynLength = TEMUSupport.temu_getPropDynLength
getPropDynLength.argtypes = [POINTER(Object), c_char_p]
getPropDynLength.restype = c_int

getPropType = TEMUSupport.temu_getPropType
getPropType.argtypes = [POINTER(Object), c_char_p]
getPropType.restype = c_uint

objectHasProp = TEMUSupport.temu_objectHasProp
objectHasProp.argtypes = [POINTER(Object), c_char_p]
objectHasProp.restype = c_int

objectHasIface = TEMUSupport.temu_objectHasIface
objectHasIface.argtypes = [POINTER(Object), c_char_p]
objectHasIface.restype = c_int

isNumber = TEMUSupport.temu_isNumber
isNumber.argtypes = [Propval]
isNumber.restype = c_int

isReal = TEMUSupport.temu_isReal
isReal.argtypes = [Propval]
isReal.restype = c_int

isDiscrete = TEMUSupport.temu_isDiscrete
isDiscrete.argtypes = [Propval]
isDiscrete.restype = c_int

isUnsigned = TEMUSupport.temu_isUnsigned
isUnsigned.argtypes = [Propval]
isUnsigned.restype = c_int

isSigned = TEMUSupport.temu_isSigned
isSigned.argtypes = [Propval]
isSigned.restype = c_int

isString = TEMUSupport.temu_isString
isString.argtypes = [Propval]
isString.restype = c_int

asInteger = TEMUSupport.temu_asInteger
asInteger.argtypes = [Propval]
asInteger.restype = c_int64

asUnsigned = TEMUSupport.temu_asUnsigned
asUnsigned.argtypes = [Propval]
asUnsigned.restype = c_uint64

asDouble = TEMUSupport.temu_asDouble
asDouble.argtypes = [Propval]
asDouble.restype = c_double

getValueU8 = TEMUSupport.temu_getValueU8
getValueU8.argtypes = [POINTER(Object), c_char_p, c_int]
getValueU8.restype = c_uint8

getValueU16 = TEMUSupport.temu_getValueU16
getValueU16.argtypes = [POINTER(Object), c_char_p, c_int]
getValueU16.restype = c_uint16

getValueU32 = TEMUSupport.temu_getValueU32
getValueU32.argtypes = [POINTER(Object), c_char_p, c_int]
getValueU32.restype = c_uint32

getValueU64 = TEMUSupport.temu_getValueU64
getValueU64.argtypes = [POINTER(Object), c_char_p, c_int]
getValueU64.restype = c_uint64

getValueI8 = TEMUSupport.temu_getValueI8
getValueI8.argtypes = [POINTER(Object), c_char_p, c_int]
getValueI8.restype = c_int8

getValueI16 = TEMUSupport.temu_getValueI16
getValueI16.argtypes = [POINTER(Object), c_char_p, c_int]
getValueI16.restype = c_int16

getValueI32 = TEMUSupport.temu_getValueI32
getValueI32.argtypes = [POINTER(Object), c_char_p, c_int]
getValueI32.restype = c_int32

getValueI64 = TEMUSupport.temu_getValueI64
getValueI64.argtypes = [POINTER(Object), c_char_p, c_int]
getValueI64.restype = c_int64

readValueU8 = TEMUSupport.temu_readValueU8
readValueU8.argtypes = [POINTER(Object), c_char_p, c_int]
readValueU8.restype = c_uint8

readValueU16 = TEMUSupport.temu_readValueU16
readValueU16.argtypes = [POINTER(Object), c_char_p, c_int]
readValueU16.restype = c_uint16

readValueU32 = TEMUSupport.temu_readValueU32
readValueU32.argtypes = [POINTER(Object), c_char_p, c_int]
readValueU32.restype = c_uint32

readValueU64 = TEMUSupport.temu_readValueU64
readValueU64.argtypes = [POINTER(Object), c_char_p, c_int]
readValueU64.restype = c_uint64

readValueI8 = TEMUSupport.temu_readValueI8
readValueI8.argtypes = [POINTER(Object), c_char_p, c_int]
readValueI8.restype = c_int8

readValueI16 = TEMUSupport.temu_readValueI16
readValueI16.argtypes = [POINTER(Object), c_char_p, c_int]
readValueI16.restype = c_int16

readValueI32 = TEMUSupport.temu_readValueI32
readValueI32.argtypes = [POINTER(Object), c_char_p, c_int]
readValueI32.restype = c_int32

readValueI64 = TEMUSupport.temu_readValueI64
readValueI64.argtypes = [POINTER(Object), c_char_p, c_int]
readValueI64.restype = c_int64

setValueU8 = TEMUSupport.temu_setValueU8
setValueU8.argtypes = [POINTER(Object), c_char_p, c_uint8, c_int]
setValueU8.restype = None

setValueU16 = TEMUSupport.temu_setValueU16
setValueU16.argtypes = [POINTER(Object), c_char_p, c_uint16, c_int]
setValueU16.restype = None

setValueU32 = TEMUSupport.temu_setValueU32
setValueU32.argtypes = [POINTER(Object), c_char_p, c_uint32, c_int]
setValueU32.restype = None

setValueU64 = TEMUSupport.temu_setValueU64
setValueU64.argtypes = [POINTER(Object), c_char_p, c_uint64, c_int]
setValueU64.restype = None

setValueI8 = TEMUSupport.temu_setValueI8
setValueI8.argtypes = [POINTER(Object), c_char_p, c_int8, c_int]
setValueI8.restype = None

setValueI16 = TEMUSupport.temu_setValueI16
setValueI16.argtypes = [POINTER(Object), c_char_p, c_int16, c_int]
setValueI16.restype = None

setValueI32 = TEMUSupport.temu_setValueI32
setValueI32.argtypes = [POINTER(Object), c_char_p, c_int32, c_int]
setValueI32.restype = None

setValueI64 = TEMUSupport.temu_setValueI64
setValueI64.argtypes = [POINTER(Object), c_char_p, c_int64, c_int]
setValueI64.restype = None

writeValueU8 = TEMUSupport.temu_writeValueU8
writeValueU8.argtypes = [POINTER(Object), c_char_p, c_uint8, c_int]
writeValueU8.restype = None

writeValueU16 = TEMUSupport.temu_writeValueU16
writeValueU16.argtypes = [POINTER(Object), c_char_p, c_uint16, c_int]
writeValueU16.restype = None

writeValueU32 = TEMUSupport.temu_writeValueU32
writeValueU32.argtypes = [POINTER(Object), c_char_p, c_uint32, c_int]
writeValueU32.restype = None

writeValueU64 = TEMUSupport.temu_writeValueU64
writeValueU64.argtypes = [POINTER(Object), c_char_p, c_uint64, c_int]
writeValueU64.restype = None

writeValueI8 = TEMUSupport.temu_writeValueI8
writeValueI8.argtypes = [POINTER(Object), c_char_p, c_int8, c_int]
writeValueI8.restype = None

writeValueI16 = TEMUSupport.temu_writeValueI16
writeValueI16.argtypes = [POINTER(Object), c_char_p, c_int16, c_int]
writeValueI16.restype = None

writeValueI32 = TEMUSupport.temu_writeValueI32
writeValueI32.argtypes = [POINTER(Object), c_char_p, c_int32, c_int]
writeValueI32.restype = None

writeValueI64 = TEMUSupport.temu_writeValueI64
writeValueI64.argtypes = [POINTER(Object), c_char_p, c_int64, c_int]
writeValueI64.restype = None

writeValueObj = TEMUSupport.temu_writeValueObj
writeValueObj.argtypes = [POINTER(Object), c_char_p, POINTER(Object), c_int]
writeValueObj.restype = None

registerClass = TEMUSupport.temu_registerClass
registerClass.argtypes = [c_char_p, CFUNCTYPE(c_void_p, c_char_p, c_int, POINTER(CreateArg)), CFUNCTYPE(None, c_void_p)]
registerClass.restype = POINTER(Class)

addProperty = TEMUSupport.temu_addProperty
addProperty.argtypes = [POINTER(Class), c_char_p, c_int, c_uint, c_int, CFUNCTYPE(None, c_void_p, Propval, c_int), CFUNCTYPE(Propval, c_void_p, c_int), c_char_p]
addProperty.restype = None

addPseudoProperty = TEMUSupport.temu_addPseudoProperty
addPseudoProperty.argtypes = [POINTER(Class), c_char_p, c_uint, c_int, CFUNCTYPE(None, c_void_p, Propval, c_int), CFUNCTYPE(Propval, c_void_p, c_int), CFUNCTYPE(None, c_void_p, Propval, c_int), CFUNCTYPE(Propval, c_void_p, c_int), c_char_p]
addPseudoProperty.restype = None

addLoggingCategory = TEMUSupport.temu_addLoggingCategory
addLoggingCategory.argtypes = [POINTER(Class), c_uint, c_char_p]
addLoggingCategory.restype = c_int

getLoggingCategory = TEMUSupport.temu_getLoggingCategory
getLoggingCategory.argtypes = [POINTER(Class), c_uint]
getLoggingCategory.restype = c_char_p

isPseudoProperty = TEMUSupport.temu_isPseudoProperty
isPseudoProperty.argtypes = [POINTER(Object), c_char_p]
isPseudoProperty.restype = c_int

isNormalProperty = TEMUSupport.temu_isNormalProperty
isNormalProperty.argtypes = [POINTER(Object), c_char_p]
isNormalProperty.restype = c_int

requireInterface = TEMUSupport.temu_requireInterface
requireInterface.argtypes = [POINTER(Class), c_char_p, c_char_p]
requireInterface.restype = None

addInterfaceReference = TEMUSupport.temu_addInterfaceReference
addInterfaceReference.argtypes = [POINTER(Class), c_char_p, c_int, c_char_p, c_int, c_uint, CFUNCTYPE(None, c_void_p, Propval, c_int), CFUNCTYPE(Propval, c_void_p, c_int), c_char_p]
addInterfaceReference.restype = None

addPseudoInterfaceReference = TEMUSupport.temu_addPseudoInterfaceReference
addPseudoInterfaceReference.argtypes = [POINTER(Class), c_char_p, c_char_p, c_int, c_uint, CFUNCTYPE(None, c_void_p, Propval, c_int), CFUNCTYPE(Propval, c_void_p, c_int), CFUNCTYPE(None, c_void_p, Propval, c_int), CFUNCTYPE(Propval, c_void_p, c_int), c_char_p]
addPseudoInterfaceReference.restype = None

addPort = TEMUSupport.temu_addPort
addPort.argtypes = [POINTER(Class), c_char_p, c_char_p, c_char_p]
addPort.restype = c_int

addInterface = TEMUSupport.temu_addInterface
addInterface.argtypes = [POINTER(Class), c_char_p, c_char_p, c_void_p, c_int, c_char_p]
addInterface.restype = None

getInterface = TEMUSupport.temu_getInterface
getInterface.argtypes = [POINTER(Object), c_char_p, c_int]
getInterface.restype = c_void_p

getInterfaceRef = TEMUSupport.temu_getInterfaceRef
getInterfaceRef.argtypes = [POINTER(Object), c_char_p, c_int]
getInterfaceRef.restype = IfaceRef

getInterfaceName = TEMUSupport.temu_getInterfaceName
getInterfaceName.argtypes = [POINTER(Object), c_void_p]
getInterfaceName.restype = c_char_p

addInterfaceArray = TEMUSupport.temu_addInterfaceArray
addInterfaceArray.argtypes = [POINTER(Class), c_char_p, c_char_p, c_void_p, c_ulong, c_ulong, c_char_p]
addInterfaceArray.restype = None

setVTable = TEMUSupport.temu_setVTable
setVTable.argtypes = [POINTER(Class), c_void_p]
setVTable.restype = c_int

getVTableForClass = TEMUSupport.temu_getVTableForClass
getVTableForClass.argtypes = [POINTER(Class)]
getVTableForClass.restype = c_void_p

getVTable = TEMUSupport.temu_getVTable
getVTable.argtypes = [POINTER(Object)]
getVTable.restype = c_void_p

setTimeSource = TEMUSupport.temu_setTimeSource
setTimeSource.argtypes = [POINTER(Object), POINTER(TimeSource)]
setTimeSource.restype = None

isQualifiedAs = TEMUSupport.temu_isQualifiedAs
isQualifiedAs.argtypes = [POINTER(Object), c_uint]
isQualifiedAs.restype = c_int

isCpu = TEMUSupport.temu_isCpu
isCpu.argtypes = [POINTER(Object)]
isCpu.restype = c_int

isMachine = TEMUSupport.temu_isMachine
isMachine.argtypes = [POINTER(Object)]
isMachine.restype = c_int

isMemory = TEMUSupport.temu_isMemory
isMemory.argtypes = [POINTER(Object)]
isMemory.restype = c_int

isComponent = TEMUSupport.temu_isComponent
isComponent.argtypes = [POINTER(Object)]
isComponent.restype = c_int

qualifyAsCpu = TEMUSupport.temu_qualifyAsCpu
qualifyAsCpu.argtypes = [POINTER(Class)]
qualifyAsCpu.restype = None

qualifyAsMachine = TEMUSupport.temu_qualifyAsMachine
qualifyAsMachine.argtypes = [POINTER(Class)]
qualifyAsMachine.restype = None

qualifyAsMemory = TEMUSupport.temu_qualifyAsMemory
qualifyAsMemory.argtypes = [POINTER(Class)]
qualifyAsMemory.restype = None

qualifyAs = TEMUSupport.temu_qualifyAs
qualifyAs.argtypes = [POINTER(Class), c_uint]
qualifyAs.restype = None

objsysClear = TEMUSupport.temu_objsysClear
objsysClear.argtypes = []
objsysClear.restype = None

objsysClearObjects = TEMUSupport.temu_objsysClearObjects
objsysClearObjects.argtypes = []
objsysClearObjects.restype = None

createObject = TEMUSupport.temu_createObject
createObject.argtypes = [c_char_p, c_char_p, POINTER(CreateArg)]
createObject.restype = POINTER(Object)

disposeObject = TEMUSupport.temu_disposeObject
disposeObject.argtypes = [POINTER(Object)]
disposeObject.restype = None

classForName = TEMUSupport.temu_classForName
classForName.argtypes = [c_char_p]
classForName.restype = POINTER(Class)

nameForClass = TEMUSupport.temu_nameForClass
nameForClass.argtypes = [POINTER(Class)]
nameForClass.restype = c_char_p

classForObject = TEMUSupport.temu_classForObject
classForObject.argtypes = [POINTER(Object)]
classForObject.restype = POINTER(Class)

classHasCommand = TEMUSupport.temu_classHasCommand
classHasCommand.argtypes = [POINTER(Class), c_char_p]
classHasCommand.restype = c_int


class PropInfo(Structure):
  pass
PropInfo._fields_ = [ 
    ('Name', c_char_p),
    ('Typ', c_uint),
    ('Count', c_ulong),
    ('Offset', c_ulong),
    ('TypeObj', c_void_p)  ]
propInfoForClass = TEMUSupport.temu_propInfoForClass
propInfoForClass.argtypes = [POINTER(Class), c_uint, c_uint, POINTER(PropInfo)]
propInfoForClass.restype = c_int

objectForName = TEMUSupport.temu_objectForName
objectForName.argtypes = [c_char_p]
objectForName.restype = POINTER(Object)

nameForObject = TEMUSupport.temu_nameForObject
nameForObject.argtypes = [POINTER(Object)]
nameForObject.restype = c_char_p

nameForInterface = TEMUSupport.temu_nameForInterface
nameForInterface.argtypes = [POINTER(Object), c_void_p]
nameForInterface.restype = c_char_p

indexForInterface = TEMUSupport.temu_indexForInterface
indexForInterface.argtypes = [POINTER(Object), c_void_p]
indexForInterface.restype = c_int

typenameForInterface = TEMUSupport.temu_typenameForInterface
typenameForInterface.argtypes = [POINTER(Object), c_void_p]
typenameForInterface.restype = c_char_p

loadPlugin = TEMUSupport.temu_loadPlugin
loadPlugin.argtypes = [c_char_p]
loadPlugin.restype = c_int

loadPluginGlobal = TEMUSupport.temu_loadPluginGlobal
loadPluginGlobal.argtypes = [c_char_p]
loadPluginGlobal.restype = c_int

pluginPathAppend = TEMUSupport.temu_pluginPathAppend
pluginPathAppend.argtypes = [c_char_p]
pluginPathAppend.restype = None

pluginPathRemove = TEMUSupport.temu_pluginPathRemove
pluginPathRemove.argtypes = [c_char_p]
pluginPathRemove.restype = None

pluginPathPrint = TEMUSupport.temu_pluginPathPrint
pluginPathPrint.argtypes = []
pluginPathPrint.restype = None

typeToName = TEMUSupport.temu_typeToName
typeToName.argtypes = [c_uint]
typeToName.restype = c_char_p

getProcessors = TEMUSupport.temu_getProcessors
getProcessors.argtypes = []
getProcessors.restype = POINTER(POINTER(Object))

getProcessorCount = TEMUSupport.temu_getProcessorCount
getProcessorCount.argtypes = []
getProcessorCount.restype = c_ulong

getComponents = TEMUSupport.temu_getComponents
getComponents.argtypes = []
getComponents.restype = POINTER(POINTER(Component))

getComponentCount = TEMUSupport.temu_getComponentCount
getComponentCount.argtypes = []
getComponentCount.restype = c_ulong

connect = TEMUSupport.temu_connect
connect.argtypes = [POINTER(Object), c_char_p, POINTER(Object), c_char_p]
connect.restype = c_int

serialiseJSON = TEMUSupport.temu_serialiseJSON
serialiseJSON.argtypes = [c_char_p]
serialiseJSON.restype = c_int

deserialiseJSON = TEMUSupport.temu_deserialiseJSON
deserialiseJSON.argtypes = [c_char_p]
deserialiseJSON.restype = c_int

inlineDeserialiseJSON = TEMUSupport.temu_inlineDeserialiseJSON
inlineDeserialiseJSON.argtypes = [c_char_p]
inlineDeserialiseJSON.restype = c_int

serialiseProp = TEMUSupport.temu_serialiseProp
serialiseProp.argtypes = [c_void_p, c_char_p, c_uint, c_int, c_void_p]
serialiseProp.restype = None

deserialiseProp = TEMUSupport.temu_deserialiseProp
deserialiseProp.argtypes = [c_void_p, POINTER(Object), c_char_p]
deserialiseProp.restype = None

snapshotGetLength = TEMUSupport.temu_snapshotGetLength
snapshotGetLength.argtypes = [c_void_p, c_char_p]
snapshotGetLength.restype = c_int

checkpointGetLength = TEMUSupport.temu_checkpointGetLength
checkpointGetLength.argtypes = [c_void_p, c_char_p]
checkpointGetLength.restype = c_int

snapshotGetValue = TEMUSupport.temu_snapshotGetValue
snapshotGetValue.argtypes = [c_void_p, c_char_p, c_int]
snapshotGetValue.restype = Propval

checkpointGetValue = TEMUSupport.temu_checkpointGetValue
checkpointGetValue.argtypes = [c_void_p, c_char_p, c_int]
checkpointGetValue.restype = Propval

checkSanity = TEMUSupport.temu_checkSanity
checkSanity.argtypes = [c_int]
checkSanity.restype = c_int

generateObjectGraph = TEMUSupport.temu_generateObjectGraph
generateObjectGraph.argtypes = [c_char_p, c_int]
generateObjectGraph.restype = c_int

isValidObjectName = TEMUSupport.temu_isValidObjectName
isValidObjectName.argtypes = [c_char_p]
isValidObjectName.restype = c_int

isValidClassName = TEMUSupport.temu_isValidClassName
isValidClassName.argtypes = [c_char_p]
isValidClassName.restype = c_int

isValidInterfaceName = TEMUSupport.temu_isValidInterfaceName
isValidInterfaceName.argtypes = [c_char_p]
isValidInterfaceName.restype = c_int

isValidPropertyName = TEMUSupport.temu_isValidPropertyName
isValidPropertyName.argtypes = [c_char_p]
isValidPropertyName.restype = c_int


class ObjectIface(Structure):
  pass
ObjectIface._fields_ = [ 
    ('serialise', CFUNCTYPE(None, c_void_p, c_char_p, c_void_p)),
    ('deserialise', CFUNCTYPE(None, c_void_p, c_char_p, c_void_p)),
    ('checkSanity', CFUNCTYPE(c_int, c_void_p, c_int)),
    ('timeSourceSet', CFUNCTYPE(None, c_void_p)),
    ('printObject', CFUNCTYPE(None, c_void_p))  ]

class ObjectIfaceRef(Structure):
  pass
ObjectIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(ObjectIface))  ]

class ObjectIfaceRefArray(Structure):
  pass
ObjectIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(ObjectIfaceRef))  ]
foreachObject = TEMUSupport.temu_foreachObject
foreachObject.argtypes = [CFUNCTYPE(None, POINTER(Object), c_void_p), c_void_p]
foreachObject.restype = None

foreachClass = TEMUSupport.temu_foreachClass
foreachClass.argtypes = [CFUNCTYPE(None, POINTER(Class), c_void_p), c_void_p]
foreachClass.restype = None

foreachProcessor = TEMUSupport.temu_foreachProcessor
foreachProcessor.argtypes = [CFUNCTYPE(None, POINTER(Object), c_void_p), c_void_p]
foreachProcessor.restype = None

foreachProperty = TEMUSupport.temu_foreachProperty
foreachProperty.argtypes = [POINTER(Class), CFUNCTYPE(None, POINTER(Class), c_char_p, c_void_p), c_void_p]
foreachProperty.restype = None

foreachInterface = TEMUSupport.temu_foreachInterface
foreachInterface.argtypes = [POINTER(Class), CFUNCTYPE(None, POINTER(Class), c_char_p, c_void_p), c_void_p]
foreachInterface.restype = None

registerInterfaceType = TEMUSupport.temu_registerInterfaceType
registerInterfaceType.argtypes = [c_char_p]
registerInterfaceType.restype = c_void_p

getInterfaceType = TEMUSupport.temu_getInterfaceType
getInterfaceType.argtypes = [c_char_p]
getInterfaceType.restype = c_void_p

addScalarProperty = TEMUSupport.temu_addScalarProperty
addScalarProperty.argtypes = [POINTER(Class), c_char_p, c_int, c_uint, c_char_p]
addScalarProperty.restype = c_int

addArrayProperty = TEMUSupport.temu_addArrayProperty
addArrayProperty.argtypes = [POINTER(Class), c_char_p, c_int, c_uint, c_int, c_char_p]
addArrayProperty.restype = c_int

addScalarPseudoProperty = TEMUSupport.temu_addScalarPseudoProperty
addScalarPseudoProperty.argtypes = [POINTER(Class), c_char_p, c_uint, c_char_p]
addScalarPseudoProperty.restype = c_int

addArrayPseudoProperty = TEMUSupport.temu_addArrayPseudoProperty
addArrayPseudoProperty.argtypes = [POINTER(Class), c_char_p, c_uint, c_int, c_char_p]
addArrayPseudoProperty.restype = c_int

writeProp = TEMUSupport.temu_writeProp
writeProp.argtypes = [POINTER(Object), c_char_p, c_int, POINTER(Propval)]
writeProp.restype = c_int

readProp = TEMUSupport.temu_readProp
readProp.argtypes = [POINTER(Object), c_char_p, c_int]
readProp.restype = Propval

getValueUnsigned = TEMUSupport.temu_getValueUnsigned
getValueUnsigned.argtypes = [POINTER(Object), c_char_p, c_int]
getValueUnsigned.restype = c_uint64

getValueSigned = TEMUSupport.temu_getValueSigned
getValueSigned.argtypes = [POINTER(Object), c_char_p, c_int]
getValueSigned.restype = c_int64

getValueDouble = TEMUSupport.temu_getValueDouble
getValueDouble.argtypes = [POINTER(Object), c_char_p, c_int]
getValueDouble.restype = c_double

readValueUnsigned = TEMUSupport.temu_readValueUnsigned
readValueUnsigned.argtypes = [POINTER(Object), c_char_p, c_int]
readValueUnsigned.restype = c_uint64

readValueSigned = TEMUSupport.temu_readValueSigned
readValueSigned.argtypes = [POINTER(Object), c_char_p, c_int]
readValueSigned.restype = c_int64

readValueDouble = TEMUSupport.temu_readValueDouble
readValueDouble.argtypes = [POINTER(Object), c_char_p, c_int]
readValueDouble.restype = c_double

setValueUnsigned = TEMUSupport.temu_setValueUnsigned
setValueUnsigned.argtypes = [POINTER(Object), c_char_p, c_uint64, c_int]
setValueUnsigned.restype = None

setValueSigned = TEMUSupport.temu_setValueSigned
setValueSigned.argtypes = [POINTER(Object), c_char_p, c_int64, c_int]
setValueSigned.restype = None

setValueDouble = TEMUSupport.temu_setValueDouble
setValueDouble.argtypes = [POINTER(Object), c_char_p, c_double, c_int]
setValueDouble.restype = None

writeValueUnsigned = TEMUSupport.temu_writeValueUnsigned
writeValueUnsigned.argtypes = [POINTER(Object), c_char_p, c_uint64, c_int]
writeValueUnsigned.restype = None

writeValueSigned = TEMUSupport.temu_writeValueSigned
writeValueSigned.argtypes = [POINTER(Object), c_char_p, c_int64, c_int]
writeValueSigned.restype = None

writeValueDouble = TEMUSupport.temu_writeValueDouble
writeValueDouble.argtypes = [POINTER(Object), c_char_p, c_double, c_int]
writeValueDouble.restype = None

signedPropval = TEMUSupport.temu_signedPropval
signedPropval.argtypes = [c_uint, c_int64]
signedPropval.restype = Propval

unsignedPropval = TEMUSupport.temu_unsignedPropval
unsignedPropval.argtypes = [c_uint, c_uint64]
unsignedPropval.restype = Propval

floatingPointPropval = TEMUSupport.temu_floatingPointPropval
floatingPointPropval.argtypes = [c_uint, c_double]
floatingPointPropval.restype = Propval

objectHasCmd = TEMUSupport.temu_objectHasCmd
objectHasCmd.argtypes = [POINTER(Object), c_char_p]
objectHasCmd.restype = c_int

