from temu.c.support.objsys import *
from ctypes import *
TEMUSupport = CDLL('libTEMUSupport.so.4')

teCS_Nominal = 0
teCS_Halted = 1
teCS_Idling = 2


teCER_Normal = 0
teCER_Trap = 2
teCER_Halt = 3
teCER_Event = 4
teCER_Break = 5
teCER_WatchR = 6
teCER_WatchW = 7
teCER_Early = 8
teCER_Panic = 9
teCER_Sync = 10


teEN_Little = 0
teEN_Big = 1
teEN_Dynamic = 2



class CpuInfo(Structure):
  pass
CpuInfo._fields_ = [ 
    ('ArchName', c_char_p),
    ('ModelName', c_char_p),
    ('VASize', c_uint),
    ('PASize', c_uint),
    ('VATypeSize', c_uint),
    ('PATypeSize', c_uint),
    ('GPRCount', c_uint),
    ('FPRCount', c_uint),
    ('InstructionEndianess', c_uint),
    ('DataEndianess', c_uint),
    ('NumInstructionSets', c_uint),
    ('InstructionSetNames', POINTER(c_char_p))  ]

class CpuIface(Structure):
  pass
CpuIface._fields_ = [ 
    ('reset', CFUNCTYPE(None, c_void_p, c_int)),
    ('run', CFUNCTYPE(c_uint, c_void_p, c_uint64)),
    ('runUntil', CFUNCTYPE(c_uint, c_void_p, c_uint64)),
    ('step', CFUNCTYPE(c_uint, c_void_p, c_uint64)),
    ('stepUntil', CFUNCTYPE(c_uint, c_void_p, c_uint64, c_uint64)),
    ('raiseTrap', CFUNCTYPE(None, c_void_p, c_int)),
    ('enterIdleMode', CFUNCTYPE(None, c_void_p)),
    ('exitEmuCore', CFUNCTYPE(None, c_void_p, c_uint)),
    ('getFreq', CFUNCTYPE(c_uint64, c_void_p)),
    ('getCycles', CFUNCTYPE(c_int64, c_void_p)),
    ('getSteps', CFUNCTYPE(c_int64, c_void_p)),
    ('getState', CFUNCTYPE(c_uint, c_void_p)),
    ('setPc', CFUNCTYPE(None, c_void_p, c_uint64)),
    ('getPc', CFUNCTYPE(c_uint64, c_void_p)),
    ('setGpr', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('getGpr', CFUNCTYPE(c_uint64, c_void_p, c_uint)),
    ('setFpr32', CFUNCTYPE(None, c_void_p, c_uint, c_uint32)),
    ('getFpr32', CFUNCTYPE(c_uint32, c_void_p, c_uint)),
    ('setFpr64', CFUNCTYPE(None, c_void_p, c_uint, c_uint64)),
    ('getFpr64', CFUNCTYPE(c_uint64, c_void_p, c_uint)),
    ('setSpr', CFUNCTYPE(None, c_void_p, c_uint, c_uint64)),
    ('getSpr', CFUNCTYPE(c_uint64, c_void_p, c_uint)),
    ('getRegId', CFUNCTYPE(c_int, c_void_p, c_char_p)),
    ('getRegName', CFUNCTYPE(c_char_p, c_void_p, c_int)),
    ('assemble', CFUNCTYPE(c_uint32, c_void_p, c_char_p)),
    ('disassemble', CFUNCTYPE(c_char_p, c_void_p, c_uint32)),
    ('enableTraps', CFUNCTYPE(None, c_void_p)),
    ('disableTraps', CFUNCTYPE(None, c_void_p)),
    ('invalidateAtc', CFUNCTYPE(None, c_void_p, c_uint64, c_uint64, c_uint32)),
    ('translateAddress', CFUNCTYPE(c_uint64, c_void_p, c_uint64, POINTER(c_uint32))),
    ('getPowerState', CFUNCTYPE(c_uint, c_void_p)),
    ('setPowerState', CFUNCTYPE(None, c_void_p, c_uint)),
    ('enableTrapEvents', CFUNCTYPE(None, c_void_p)),
    ('disableTrapEvents', CFUNCTYPE(None, c_void_p)),
    ('enableErrorModeEvents', CFUNCTYPE(None, c_void_p)),
    ('disableErrorModeEvents', CFUNCTYPE(None, c_void_p)),
    ('getMachine', CFUNCTYPE(c_void_p, c_void_p)),
    ('raiseTrapNoJmp', CFUNCTYPE(None, c_void_p, c_int)),
    ('getTrapName', CFUNCTYPE(c_char_p, c_void_p, c_int)),
    ('getCPUInfo', CFUNCTYPE(POINTER(CpuInfo), c_void_p)),
    ('wakeUp', CFUNCTYPE(c_int, c_void_p)),
    ('forceEarlyExit', CFUNCTYPE(None, c_void_p)),
    ('translateIRAddress', CFUNCTYPE(c_void_p, c_void_p, c_uint64)),
    ('enableModeSwitchEvents', CFUNCTYPE(None, c_void_p)),
    ('disableModeSwitchEvents', CFUNCTYPE(None, c_void_p)),
    ('enableProfiling', CFUNCTYPE(None, c_void_p)),
    ('disableProfiling', CFUNCTYPE(None, c_void_p)),
    ('flushProfileCaches', CFUNCTYPE(None, c_void_p)),
    ('getIdleSteps', CFUNCTYPE(c_int64, c_void_p)),
    ('getIdleCycles', CFUNCTYPE(c_int64, c_void_p)),
    ('enterHaltedMode', CFUNCTYPE(None, c_void_p)),
    ('forceSpecificExit', CFUNCTYPE(None, c_void_p, c_uint)),
    ('purgeDirtyPages', CFUNCTYPE(None, c_void_p)),
    ('invalidateFetchAtc', CFUNCTYPE(None, c_void_p)),
    ('translateAddressWithRoot', CFUNCTYPE(c_int, c_void_p, c_uint64, POINTER(c_uint32), c_uint64, POINTER(c_uint64))),
    ('synchronizingRun', CFUNCTYPE(c_uint, c_void_p, c_uint64)),
    ('synchronizingRunUntil', CFUNCTYPE(c_uint, c_void_p, c_uint64)),
    ('synchronizingStep', CFUNCTYPE(c_uint, c_void_p, c_uint64)),
    ('synchronizingStepUntil', CFUNCTYPE(c_uint, c_void_p, c_uint64, c_uint64))  ]


class CpuIfaceRef(Structure):
  pass
CpuIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(CpuIface))  ]

class CpuIfaceRefArray(Structure):
  pass
CpuIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(CpuIfaceRef))  ]

class TrapEventInfo(Structure):
  pass
TrapEventInfo._fields_ = [ 
    ('TrapId', c_uint32),
    ('PC', c_uint64),
    ('nPC', c_uint64)  ]

class ModeSwitchInfo(Structure):
  pass
ModeSwitchInfo._fields_ = [ 
    ('OldMode', c_uint32),
    ('NewMode', c_uint32)  ]

class ResetInfo(Structure):
  pass
ResetInfo._fields_ = [ 
    ('ResetType', c_int)  ]

class TargetExecutionIface(Structure):
  pass
TargetExecutionIface._fields_ = [ 
    ('profileCounterOverflow', CFUNCTYPE(None, c_void_p, c_uint64)),
    ('wrotePage', CFUNCTYPE(None, c_void_p, c_uint64, c_uint64)),
    ('getRawRuntime', CFUNCTYPE(c_void_p, c_void_p))  ]

class TargetExecutionIfaceRef(Structure):
  pass
TargetExecutionIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(TargetExecutionIface))  ]

class TargetExecutionIfaceRefArray(Structure):
  pass
TargetExecutionIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(TargetExecutionIfaceRef))  ]

class DynamicResetAddressIface(Structure):
  pass
DynamicResetAddressIface._fields_ = [ 
    ('setResetAddress', CFUNCTYPE(None, c_void_p, c_uint64)),
    ('getResetAddress', CFUNCTYPE(c_uint64, c_void_p))  ]

class DynamicResetAddressIfaceRef(Structure):
  pass
DynamicResetAddressIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(DynamicResetAddressIface))  ]

class DynamicResetAddressIfaceRefArray(Structure):
  pass
DynamicResetAddressIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(DynamicResetAddressIfaceRef))  ]

class BinaryTranslationControlIface(Structure):
  pass
BinaryTranslationControlIface._fields_ = [ 
    ('enableBinaryTranslator', CFUNCTYPE(None, c_void_p)),
    ('disableBinaryTranslator', CFUNCTYPE(None, c_void_p)),
    ('setThreshold', CFUNCTYPE(None, c_void_p, c_uint)),
    ('translateInstructions', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64, c_uint)),
    ('translateBlock', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64)),
    ('translateFunc', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64)),
    ('chainBlocks', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64, c_int)),
    ('disassembleBlock', CFUNCTYPE(c_char_p, c_void_p, c_uint64)),
    ('clearBlock', CFUNCTYPE(c_int, c_void_p, c_uint64)),
    ('clearBlocksOnPage', CFUNCTYPE(c_int, c_void_p, c_uint64)),
    ('enableStatistics', CFUNCTYPE(None, c_void_p, c_uint)),
    ('disableStatistics', CFUNCTYPE(None, c_void_p, c_uint)),
    ('getStatistics', CFUNCTYPE(c_uint64, c_void_p, c_uint)),
    ('clearStatistics', CFUNCTYPE(None, c_void_p, c_uint))  ]

class BinaryTranslationControlIfaceRef(Structure):
  pass
BinaryTranslationControlIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(BinaryTranslationControlIface))  ]

class BinaryTranslationControlIfaceRefArray(Structure):
  pass
BinaryTranslationControlIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(BinaryTranslationControlIfaceRef))  ]
from temu.c.support.objsys import *
from ctypes import *
TEMUSupport = CDLL('libTEMUSupport.so.4')

teCS_Nominal = 0
teCS_Halted = 1
teCS_Idling = 2


teCER_Normal = 0
teCER_Trap = 2
teCER_Halt = 3
teCER_Event = 4
teCER_Break = 5
teCER_WatchR = 6
teCER_WatchW = 7
teCER_Early = 8
teCER_Panic = 9
teCER_Sync = 10


teEN_Little = 0
teEN_Big = 1
teEN_Dynamic = 2



class CpuInfo(Structure):
  pass
CpuInfo._fields_ = [ 
    ('ArchName', c_char_p),
    ('ModelName', c_char_p),
    ('VASize', c_uint),
    ('PASize', c_uint),
    ('VATypeSize', c_uint),
    ('PATypeSize', c_uint),
    ('GPRCount', c_uint),
    ('FPRCount', c_uint),
    ('InstructionEndianess', c_uint),
    ('DataEndianess', c_uint),
    ('NumInstructionSets', c_uint),
    ('InstructionSetNames', POINTER(c_char_p))  ]

class CpuIface(Structure):
  pass
CpuIface._fields_ = [ 
    ('reset', CFUNCTYPE(None, c_void_p, c_int)),
    ('run', CFUNCTYPE(c_uint, c_void_p, c_uint64)),
    ('runUntil', CFUNCTYPE(c_uint, c_void_p, c_uint64)),
    ('step', CFUNCTYPE(c_uint, c_void_p, c_uint64)),
    ('stepUntil', CFUNCTYPE(c_uint, c_void_p, c_uint64, c_uint64)),
    ('raiseTrap', CFUNCTYPE(None, c_void_p, c_int)),
    ('enterIdleMode', CFUNCTYPE(None, c_void_p)),
    ('exitEmuCore', CFUNCTYPE(None, c_void_p, c_uint)),
    ('getFreq', CFUNCTYPE(c_uint64, c_void_p)),
    ('getCycles', CFUNCTYPE(c_int64, c_void_p)),
    ('getSteps', CFUNCTYPE(c_int64, c_void_p)),
    ('getState', CFUNCTYPE(c_uint, c_void_p)),
    ('setPc', CFUNCTYPE(None, c_void_p, c_uint64)),
    ('getPc', CFUNCTYPE(c_uint64, c_void_p)),
    ('setGpr', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('getGpr', CFUNCTYPE(c_uint64, c_void_p, c_uint)),
    ('setFpr32', CFUNCTYPE(None, c_void_p, c_uint, c_uint32)),
    ('getFpr32', CFUNCTYPE(c_uint32, c_void_p, c_uint)),
    ('setFpr64', CFUNCTYPE(None, c_void_p, c_uint, c_uint64)),
    ('getFpr64', CFUNCTYPE(c_uint64, c_void_p, c_uint)),
    ('setSpr', CFUNCTYPE(None, c_void_p, c_uint, c_uint64)),
    ('getSpr', CFUNCTYPE(c_uint64, c_void_p, c_uint)),
    ('getRegId', CFUNCTYPE(c_int, c_void_p, c_char_p)),
    ('getRegName', CFUNCTYPE(c_char_p, c_void_p, c_int)),
    ('assemble', CFUNCTYPE(c_uint32, c_void_p, c_char_p)),
    ('disassemble', CFUNCTYPE(c_char_p, c_void_p, c_uint32)),
    ('enableTraps', CFUNCTYPE(None, c_void_p)),
    ('disableTraps', CFUNCTYPE(None, c_void_p)),
    ('invalidateAtc', CFUNCTYPE(None, c_void_p, c_uint64, c_uint64, c_uint32)),
    ('translateAddress', CFUNCTYPE(c_uint64, c_void_p, c_uint64, POINTER(c_uint32))),
    ('getPowerState', CFUNCTYPE(c_uint, c_void_p)),
    ('setPowerState', CFUNCTYPE(None, c_void_p, c_uint)),
    ('enableTrapEvents', CFUNCTYPE(None, c_void_p)),
    ('disableTrapEvents', CFUNCTYPE(None, c_void_p)),
    ('enableErrorModeEvents', CFUNCTYPE(None, c_void_p)),
    ('disableErrorModeEvents', CFUNCTYPE(None, c_void_p)),
    ('getMachine', CFUNCTYPE(c_void_p, c_void_p)),
    ('raiseTrapNoJmp', CFUNCTYPE(None, c_void_p, c_int)),
    ('getTrapName', CFUNCTYPE(c_char_p, c_void_p, c_int)),
    ('getCPUInfo', CFUNCTYPE(POINTER(CpuInfo), c_void_p)),
    ('wakeUp', CFUNCTYPE(c_int, c_void_p)),
    ('forceEarlyExit', CFUNCTYPE(None, c_void_p)),
    ('translateIRAddress', CFUNCTYPE(c_void_p, c_void_p, c_uint64)),
    ('enableModeSwitchEvents', CFUNCTYPE(None, c_void_p)),
    ('disableModeSwitchEvents', CFUNCTYPE(None, c_void_p)),
    ('enableProfiling', CFUNCTYPE(None, c_void_p)),
    ('disableProfiling', CFUNCTYPE(None, c_void_p)),
    ('flushProfileCaches', CFUNCTYPE(None, c_void_p)),
    ('getIdleSteps', CFUNCTYPE(c_int64, c_void_p)),
    ('getIdleCycles', CFUNCTYPE(c_int64, c_void_p)),
    ('enterHaltedMode', CFUNCTYPE(None, c_void_p)),
    ('forceSpecificExit', CFUNCTYPE(None, c_void_p, c_uint)),
    ('purgeDirtyPages', CFUNCTYPE(None, c_void_p)),
    ('invalidateFetchAtc', CFUNCTYPE(None, c_void_p)),
    ('translateAddressWithRoot', CFUNCTYPE(c_int, c_void_p, c_uint64, POINTER(c_uint32), c_uint64, POINTER(c_uint64))),
    ('synchronizingRun', CFUNCTYPE(c_uint, c_void_p, c_uint64)),
    ('synchronizingRunUntil', CFUNCTYPE(c_uint, c_void_p, c_uint64)),
    ('synchronizingStep', CFUNCTYPE(c_uint, c_void_p, c_uint64)),
    ('synchronizingStepUntil', CFUNCTYPE(c_uint, c_void_p, c_uint64, c_uint64))  ]


class CpuIfaceRef(Structure):
  pass
CpuIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(CpuIface))  ]

class CpuIfaceRefArray(Structure):
  pass
CpuIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(CpuIfaceRef))  ]

class TrapEventInfo(Structure):
  pass
TrapEventInfo._fields_ = [ 
    ('TrapId', c_uint32),
    ('PC', c_uint64),
    ('nPC', c_uint64)  ]

class ModeSwitchInfo(Structure):
  pass
ModeSwitchInfo._fields_ = [ 
    ('OldMode', c_uint32),
    ('NewMode', c_uint32)  ]

class ResetInfo(Structure):
  pass
ResetInfo._fields_ = [ 
    ('ResetType', c_int)  ]

class TargetExecutionIface(Structure):
  pass
TargetExecutionIface._fields_ = [ 
    ('profileCounterOverflow', CFUNCTYPE(None, c_void_p, c_uint64)),
    ('wrotePage', CFUNCTYPE(None, c_void_p, c_uint64, c_uint64)),
    ('getRawRuntime', CFUNCTYPE(c_void_p, c_void_p))  ]

class TargetExecutionIfaceRef(Structure):
  pass
TargetExecutionIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(TargetExecutionIface))  ]

class TargetExecutionIfaceRefArray(Structure):
  pass
TargetExecutionIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(TargetExecutionIfaceRef))  ]

class DynamicResetAddressIface(Structure):
  pass
DynamicResetAddressIface._fields_ = [ 
    ('setResetAddress', CFUNCTYPE(None, c_void_p, c_uint64)),
    ('getResetAddress', CFUNCTYPE(c_uint64, c_void_p))  ]

class DynamicResetAddressIfaceRef(Structure):
  pass
DynamicResetAddressIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(DynamicResetAddressIface))  ]

class DynamicResetAddressIfaceRefArray(Structure):
  pass
DynamicResetAddressIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(DynamicResetAddressIfaceRef))  ]

class BinaryTranslationControlIface(Structure):
  pass
BinaryTranslationControlIface._fields_ = [ 
    ('enableBinaryTranslator', CFUNCTYPE(None, c_void_p)),
    ('disableBinaryTranslator', CFUNCTYPE(None, c_void_p)),
    ('setThreshold', CFUNCTYPE(None, c_void_p, c_uint)),
    ('translateInstructions', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64, c_uint)),
    ('translateBlock', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64)),
    ('translateFunc', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64)),
    ('chainBlocks', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64, c_int)),
    ('disassembleBlock', CFUNCTYPE(c_char_p, c_void_p, c_uint64)),
    ('clearBlock', CFUNCTYPE(c_int, c_void_p, c_uint64)),
    ('clearBlocksOnPage', CFUNCTYPE(c_int, c_void_p, c_uint64)),
    ('enableStatistics', CFUNCTYPE(None, c_void_p, c_uint)),
    ('disableStatistics', CFUNCTYPE(None, c_void_p, c_uint)),
    ('getStatistics', CFUNCTYPE(c_uint64, c_void_p, c_uint)),
    ('clearStatistics', CFUNCTYPE(None, c_void_p, c_uint))  ]

class BinaryTranslationControlIfaceRef(Structure):
  pass
BinaryTranslationControlIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(BinaryTranslationControlIface))  ]

class BinaryTranslationControlIfaceRefArray(Structure):
  pass
BinaryTranslationControlIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(BinaryTranslationControlIfaceRef))  ]
