//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2015, 2020
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_BUS_GPIO_H
#define TEMU_BUS_GPIO_H

#include "temu-c/Support/Objsys.h"
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * These interfaces have been deprecated,
 * new GPIO devices should use the SignalIface
 */

/*!
 * Interface implemented by the GPIO bus class.
 *
 * Normally this does not have to be implemented yourself. It exist
 * for the bus model only. In-case you need a separate bus model, you
 * can implement this interface.
 * 
 * Note that this interface is deprecated for future models and it is
 * expected that the signal interface is used instead.
 */
typedef struct temu_GpioBusIface {
  //! setGpioBits should set or clear the bits in Bits if they are set
  //! in Mask. Upon a set, the GPIO bus model should notify any
  //! connected GPIO clients about the changed bits. This is done
  //! using the temu_GpioClientIface. In the built in bus model,
  //! notifications are only delivered if any of the bits actually
  //! changed.
  void (*setGpioBits)(void *Obj, uint64_t Bits, uint64_t Mask);

  //! Get the gpio-bits currently on the bus. The bits in mask will be
  //! extracted from the bus and returned in the result.
  uint64_t (*getGpioBits)(void *Obj, uint64_t Mask);
} temu_GpioBusIface;
#define TEMU_GPIO_BUS_IFACE_TYPE "GpioBusIface"
TEMU_IFACE_REFERENCE_TYPE(temu_GpioBus);

/*!
 * Interface for GPIO clients.
 *
 * A GPIO client is a device that interface with the GPIO bus. Such a
 * client can poll using the GpioBusIface, but it is likely better to
 * be lazily notified about changes to the bus values. Such
 * notifications will be delivered to the GpioClientIface.
 *
 * Note that this interface is deprecated for future models and it is
 * expected that the signal interface is used instead.
 */
typedef struct temu_GpioClientIface {
  //! Notification function. A client will always be notified about
  //! changed bus values. The Bus value is indicated in the Bits
  //! param, and the values that where changed are indicated in the
  //! Mask param.
  void (*gpioBitsChanged)(void *Obj, uint64_t Bits, uint64_t Mask);
} temu_GpioClientIface;
#define TEMU_GPIO_CLIENT_IFACE_TYPE "GpioClientIface"
TEMU_IFACE_REFERENCE_TYPE(temu_GpioClient);


#ifdef __cplusplus
}
#endif

#endif /* ! TEMU_BUS_GPIO_H */
