//===-- temu-c/GdbServer.h - GdbServer API ------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2015
// Authors: Mattias Holm <maho@terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_GDBSERVER_H
#define TEMU_GDBSERVER_H

/**!
 * Deprecated library
 * 
 * The GDB server library has been deprecated in favour
 * of the GdbDebugger plugin.
 * 
 * The GDB debugger plugin supports running the GDB server in a separate thread,
 * and works with the TEMU Scheduler.
 * 
 * This server is still around for the time beeing, since it is compatible with
 * the Machine model.
 * 
 * This server library is expected to be removed in TEMU 5.
*/

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif
//! Initialise the GDB Server Library
void temu_initGdbServerLib(void);

//! Create a new GDB server
//!
//! \param Port TCP port to start server on.
//! \result Opaque handle to GDB server.
void* temu_createGdbServer(uint16_t Port);

//! Dispose a GDB server
//!
//! \param Gdb Pointer returned by `temu_createGdbServer()`
void temu_disposeGdbServer(void *Gdb);

//! Wait current thread for a user to connect
//!
//! \param Gdb Pointer returned by `temu_createGdbServer()`
void temu_gdbWaitForConnection(void *Gdb);

//! Add named machine to GDB server
//!
//! \param Gdb Pointer returned by `temu_createGdbServer()`
//! \param MachineName Name of `Machine` object.
void temu_gdbAddMachine(void *Gdb, const char *MachineName);

//! Add named CPU to GDB server
//!
//! \param Gdb Pointer returned by `temu_createGdbServer()`
//! \param CpuName Name of processor object.
void temu_gdbAddCpu(void *Gdb, const char *CpuName);

//! Tell GDB server to stop at next safe point in time.
//!
//! \param Gdb Pointer returned by `temu_createGdbServer()`
void temu_gdbAsyncStop(void *Gdb);

//! Run the GDB server loop
//!
//! \param Gdb Pointer returned by `temu_createGdbServer()`
int temu_gdbRun(void *Gdb);

#ifdef __cplusplus
}
#endif


#endif /* TEMU_GDBSERVER_H */
