//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2016
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_CLOCK_H
#define TEMU_CLOCK_H

#include "temu-c/Support/Objsys.h"
#include "temu-c/Support/Events.h"

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * THIS INTERFACE IS EXPERIMENTAL AND UNSTABLE
 */

/*!
 * Clock stop reason, these are similar to CPU exit reason, but not
 * identical.
 */
typedef enum {
  teCSR_Normal = 0, //!< Normal exit (cannot be passed to early exit)
  teCSR_Halt,       //!< Exited due to clock halting
  teCSR_BreakWatch, //!< Exited due to breakpoint or watchpoint hit
  teCSR_Early,      //!< Other early stop reason
  teCSR_Panic,      //!< Clock had a serious internal error
  teCSR_Sync,       //!< Clock needs to synchronize
} temu_ClockStopReason;

typedef struct {
  temu_ClockStopReason (*step)(void *Obj, uint64_t Steps);
  temu_ClockStopReason (*stepUntil)(void *Obj, uint64_t Steps, uint64_t Cycles);
  temu_ClockStopReason (*advanceCycles)(void *Obj, uint64_t Cycles);
  temu_ClockStopReason (*advanceToCycles)(void *Obj, uint64_t Cycles);

  uint64_t (*getSteps)(void *Obj);
  uint64_t (*getCycles)(void *Obj);
  uint64_t (*getNanos)(void *Obj);
  double (*getSecs)(void *Obj);
  /* Set time to arbitrary values without executing events */
  void (*setSteps)(void *Obj, uint64_t Steps);
  void (*setCycles)(void *Obj, uint64_t Ticks);
  void (*setNanos)(void *Obj, uint64_t Nanos);
  void (*setSecs)(void *Obj, double Secs);

  double (*getFreq)(void *Obj);
  void (*setFreq)(void *Obj, double Freq);


  temu_ClockStopReason (*synchronizingAdvanceCycles)(void *Obj, uint64_t Cycles);
  temu_ClockStopReason (*synchronizingAdvanceToCycles)(void *Obj, uint64_t Cycles);
  temu_ClockStopReason (*synchronizingStep)(void *Obj, uint64_t Steps);
  temu_ClockStopReason (*synchronizingStepUntil)(void *Obj, uint64_t Steps, uint64_t Cycles);

} temu_ClockIface;

#define TEMU_CLOCK_IFACE_TYPE "ClockIface"
TEMU_IFACE_REFERENCE_TYPE(temu_Clock);



typedef struct {
  temu_ClockIface *Clock;
} temu_ClockVTable;



#ifdef __cplusplus
}
#endif

#endif /* ! TEMU_CLOCK_H */
