# Simple MMIO Model

This plugin shows how to create a simple MMIO model for TEMU.

## Building

The plugin can be built with the Makefile, just type make, but take
into account that if you have installed TEMU in a non-standard
location, then the paths in the makefile need to be adapted.

## Running

Start the temu command line interface and load the plugin as follows:

  temu> import MMIOModel

First create a processor instance:

  temu> exec /opt/temu/2.1.0/share/temu/sysconfig/leon2.temu

Then create an object:

  temu> MMIOModel.new name=myModel

And map it into memory:

  temu> memory-map memspace=mem0 addr=0x20000000 length=0x128 object=myModel

Stimulate the model with a test program:

  temu> assemble cpu=cpu0 instr="st %g1, [%g2 + 0]"
  temu> set-reg cpu=cpu0 reg="%g2" value=0x20000000
  temu> set-reg cpu=cpu0 reg="%g1" value=42
  temu> step cpu=cpu0 steps=1
  temu> object-info obj=myModel
