//===-- temu-c/Attributes.h - Compiler attributes ---------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2016
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

//
// This header allows the user to control the emission of deprecation
// warnings and unused argument warnings (which tend to be common due
// to interfaces being general purpose). To omit the standard
// attributes simply redefine them before you include this header.
//

#ifndef __has_feature
# define __has_feature(x) 0
#endif

#ifndef TEMU_DEPRECATED
# define TEMU_DEPRECATED __attribute__((deprecated))
#endif

/*
  Unused is used on unused parameters, this instead of using the old
  style trick (void)param; Unused parameters are fairly common in TEMU
  based code as interfaces will by necesity force function signatures
  in a way that is beyond the influence of API user.
 */
#ifndef TEMU_UNUSED
# define TEMU_UNUSED __attribute__((unused))
#endif

/* GCC does support nonnull, but it must be used on the function iteslf
   giving the nonnull parameter indices in a list.
   This is not what we indend here. TEMU_NONNULL should be used on the
   parameters directly, this usage is supported by clang, so we get
   some additional checking in clang this way.

   Ofcourse, the purpose of the attribute is to document the API in a
   somewhat concise way, so in either case we should try to used the
   attribute even if it does not have a meaning in GCC.
*/
#ifndef TEMU_NONNULL
# ifdef __clang__
#  define TEMU_NONNULL __attribute__((nonnull))
# else
#  define TEMU_NONNULL
# endif
#endif

#ifndef TEMU_API
#  define TEMU_API __attribute__((visibility("default")))
#endif

#ifndef TEMU_INTERNAL
#  define TEMU_INTERNAL __attribute__ ((visibility ("hidden")))
#endif

#ifndef TEMU_MAYBE_UNUSED
#  define TEMU_MAYBE_UNUSED __attribute__ ((unused))
#endif
