# TEMU Examples

This directory contains several examples of how to implement plugins
and models in TEMU.

## Hello Plugin

The hello-plugin shows how to create a simple plugin that prints a
message on loading.

## Simple Pluign

The simple-plugin is a plugin that is more complex than hello-plugin,
it illustrates how to create classes with properties and property
handlers.

## Simple MMIO Model

Extending on the simple plugin, the simple MMIO model provides a class
that also implements the MMIO interface. The instructions for the
example show how to stimulate the MMIO interface from the emulator
core as well.

## Simple Simulator

The simple simulator provides an example of how run TEMU embedded in
another application (e.g. a simulator). This uses the function
interface. Although, it is recommended that the low level direct
interface is used for performance reason.

## Interface Example

This example shows how to connect interface references and use these
to control other objects. The exapmple shows how to post timed events
on the CPU event queue.

## CAN Device Example

This example shows how to create a CAN device model. A CAN device is
typically a remote terminal, but could also be a CAN device integrated
with MMIO to a processor model (e.g. CAN_OC). The example provides an
OBSW image based on RTEMS (both in ELF and C format). Plus step by
step instructions of how to setup an UT700 and connect it and a user
provided CAN device to a CAN bus.

## CAN Bus Example

This examples show how to implement a CAN bus model in C++.
A generic bus model broadcasts all CAN frames,
but it is expected that mission specific bus models are needed.
Hence, a starting point which works,
essentially the same as SimpleCANBus model is provided here.
