//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2015
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_DEVICE_H
#define TEMU_DEVICE_H

#include "temu-c/Support/Objsys.h"

#ifdef __cplusplus
extern "C" {
#endif

/*!
  Standard device interface
  
  \field reset Called when the device is reset.
  \field mapDevice If defined, called when a device is mapped.
 */
typedef struct temu_DeviceIface {
  void (*reset)(void *Obj, int ResetType);
  void (*mapDevice)(void *Obj, uint64_t Address, uint64_t Len);
} temu_DeviceIface;
#define TEMU_DEVICE_IFACE_TYPE "DeviceIface"
TEMU_IFACE_REFERENCE_TYPE(temu_Device);

#ifdef __cplusplus
}
#endif

#endif /* ! TEMU_DEVICE_H */
