//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2015, 2016
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_MACHINE_H
#define TEMU_MACHINE_H

#include "temu-c/Support/Cpu.h"
#include "temu-c/Target/Cpu.h"
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/*!
  Standard machine interface
 */
typedef struct temu_MachineIface {
  //! Send reset to all processors in the machine
  void (*reset)(void *Obj, int ResetType);
  //! Run the machine for the given time
  temu_CpuExitReason (*run)(void *Obj, uint64_t NanoSecs);

  //! Step the given process a number of steps.
  temu_CpuExitReason (*step)(void *Obj, int CpuId, uint64_t Steps);
  //! Get current processor.
  temu_CpuIfaceRef (*getCurrentCpu)(void *Obj);
  //! Get processor by index.
  temu_CpuIfaceRef (*getCpu)(void *Obj, unsigned Idx);
  //! Get machine time in nanoseconds.
  int64_t (*getTime)(void *Machine);

  //! Return the current CPU number
  unsigned (*getCurrentCpuId)(void *Obj);

  //! Async stop must be async safe, it can be used to tell the
  //! emulator to stop in an async safe way, e.g. from a signal
  //! handler.
  void (*asyncStop)(void *Obj);
} temu_MachineIface;
#define TEMU_MACHINE_IFACE_TYPE "MachineIface"
TEMU_IFACE_REFERENCE_TYPE(temu_Machine);

#ifdef __cplusplus
}
#endif

#endif /* ! TEMU_DEVICE_H */
