# CAN Device Example

This plugin shows how to create a CAN device model and how to connect
it to a CAN bus.

## Building

The plugin can be built with the Makefile, just type make, but take
into account that if you have installed TEMU in a non-standard
location, then the paths in the makefile need to be adapted.

## Running

Start the temu command line interface and load the plugin as follows:

Firstly we create a UT700 processor instance, and then a CAN bus, and
CAN device.

  temu> exec ut700.temu
  temu> import BusModels
  temu> import CANDevice

Then create a CAN bus, device object and connect them:

  temu> SimpleCANBus.new name=canbus0
  temu> CanDevice.new name=mydev0

  temu> connect-timesource obj=mydev0 ts=cpu0
  temu> can-connect bus=canbus0:CanBusIface dev=mydev0:CanDevIface

Also connect the can devices provided by the UT700:

  temu> can-connect bus=canbus0:CanBusIface dev=canoc0:CanDevIface
  temu> can-connect bus=canbus0:CanBusIface dev=canoc1:CanDevIface

This done, it is time to load some on-board software, we fake a boot
loader by loading the obsw directly and setting the program counter
and the stack and frame pointers.

  temu> load obj=cpu0 file=obsw.elf

  temu> cpu-set-pc cpu=cpu0 pc=0x40000000
  temu> cpu-set-reg cpu=cpu0 reg="%fp" value=0x40040000
  temu> cpu-set-reg cpu=cpu0 reg="%sp" value=0x40040000

Then run it:
  temu> run obj=cpu0 time=2.0
