#include <stdint.h>
#include <stdio.h>
#include <string.h>

#include "temu-c/Support/Init.h"
#include "temu-c/Support/Objsys.h"
#include "temu-c/Support/Loader.h"
#include "temu-c/Support/Cpu.h"
#include "temu-c/Support/CommandLine.h"
#include "temu-c/Target/Cpu.h"

int
main(int argc, const char *argv[argc])
{
  temu_initSupportLib();

  // For this to work, the command temu must be available in your
  // $PATH.
  temu_initPathSupport("temu");
  // You can give a full path, but assuming the initPathSupport was
  // called you can just request the file directly, exec paths will be
  // initialised with /opt/temu/x.y.z/share/temu/sysconfig by default.
  temu_execCommandFile("leon2.temu");

  void *Cpu = temu_objectForName("cpu0");
  temu_loadImage(Cpu, "obsw.elf");

  temu_cpuSetPc(Cpu, 0x40000000);
  temu_cpuSetReg(Cpu, 30, 0x40040000); // SPARC frame pointer %fp
  temu_cpuSetReg(Cpu, 14, 0x40040000); // SPARC stack pointer %sp


  // There are two ways to run a processor the one commented out is
  // the direct interface usage approach, this is in general more
  // recommended than the function interface for performance reasons.

  //  temu_CpuIface *CpuIface = temu_getInterface(Cpu, "CpuIface", 0);
  //  CpuIface->run(Cpu, UINT64_C(100000000));

  // This is the function based interface, it is much cleaner, but in
  // some cases, the function interface must query for interfaces by
  // name, this is a costly operation that you want to avoid. In the
  // case of temu_cpu* functions, these do not have to query
  // interfaces by name and uses quick lookup through the super-object
  // instead.
  temu_cpuRun(Cpu, UINT64_C(100000000));

  return 0;
}
