//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2021
// Authors: Daria Vorotnikova <davo (at) terma.com>
//
//===----------------------------------------------------------------------===//
#ifndef TEMU_PCI_DEFINE_H
#define TEMU_PCI_DEFINE_H

//===----------------------------------------------------------------------===//
//
// NOTE: PCI and PCIe interfaces is an experimental and unstable API
//       It is subject to change until it is deemed stable enough.
//
//===----------------------------------------------------------------------===//

// Base and subclass codes valid for PCI and PCIe
#define tePciBc_Pre 0x00
#define tePciSc_Any 0x00
#define tePciSc_Vga 0x01

#define tePciBc_MassStorageController 0x01
#define tePciSc_ScsiBusController 0x00
#define tePciSc_IdeController 0x01
#define tePciSc_FloppyDiskController 0x02
#define tePciSc_IpiBusController 0x03
#define tePciSc_RaidController 0x04
#define tePciSc_AtaController 0x05
#define tePciSc_SataController 0x06 // Serial ATA
#define tePciSc_SasController 0x07  // Serial attached SCSI
#define tePciSc_OtherMassStorageController 0x80

#define tePciBc_NetworkController 0x02
#define tePciSc_EthernetController 0x00
#define tePciSc_TokenRingController 0x01
#define tePciSc_FddiController 0x02
#define tePciSc_AtmController 0x03
#define tePciSc_IsdnController 0x04
#define tePciSc_WorldFipController 0x05
#define tePciSc_PicmgMultiComputing 0x06
#define tePciSc_OtherNetworkController 0x80

#define tePciBc_DisplayController 0x03
#define tePciSc_VgaController 0x00
#define tePciSc_XgaController 0x01
#define tePciSc_3dController 0x02
#define tePciSc_OtherDisplayController 0x80

#define tePciBc_MultimedaiDevice 0x04
#define tePciSc_VideoDevice 0x00
#define tePciSc_AudioDevice 0x01
#define tePciSc_ComptuterTelephonyDevice 0x02
#define tePciSc_OtherMultimediaDevice 0x80

#define tePciBc_MemoryController 0x05
#define tePciSc_RAM 0x00
#define tePciSc_Flash 0x01
#define tePciSc_OtherMemoryController 0x80

#define tePciBc_BridgeDevice 0x06
#define tePciSc_HostBridge 0x00
#define tePciSc_IsaBridge 0x01
#define tePciSc_EisaBridge 0x02
#define tePciSc_McaBridge 0x03
#define tePciSc_PciToPciBridge 0x04
#define tePciSc_PcmciaBridge 0x05
#define tePciSc_NuBusBridge 0x06
#define tePciSc_CardBusBridge 0x07
#define tePciSc_RaceWayBridge 0x08
#define tePciSc_SemiTransparentPciToPciBridge 0x09
#define tePciSc_InfiniBandToPciHostBridge 0x0a
#define tePciSc_OtherBridgeDevice 0x80

#define tePciBc_SimpleCommunicationController 0x07
#define tePciSc_SerialController 0x00
#define tePciSc_ParallelPort 0x01
#define tePciSc_MultiPortSerialController 0x02
#define tePciSc_Modem 0x03
#define tePciSc_GpibController 0x04
#define tePciSc_SmartCard 0x05
#define tePciSc_OtherCommunicationsDevice 0x80

#define tePciBc_BaseSystemPeripheral 0x08
#define tePciSc_Pic 0x00
#define tePciSc_DmaController 0x01
#define tePciSc_SystemTimer 0x02
#define tePciSc_RtcController 0x03
#define tePciSc_PciHotPlugController 0x04
#define tePciSc_SdHostController 0x05
#define tePciSc_OtherSystemPeripheral 0x80

#define tePciBc_InputDevice 0x09
#define tePciSc_KeyboardController 0x00
#define tePciSc_Digitizer 0x01
#define tePciSc_MouseController 0x02
#define tePciSc_ScannerController 0x03
#define tePciSc_GameportController 0x04
#define tePciSc_OtherInputController 0x80

#define tePciBc_DockingStation 0x0a
#define tePciSc_GenericDockingStation 0x00
#define tePciSc_OtherDockingStation 0x80

#define tePciBc_Processor 0x0b
#define tePciSc_386 0x00
#define tePciSc_486 0x01
#define tePciSc_Pentium 0x02
#define tePciSc_Alpha 0x10
#define tePciSc_PowerPC 0x20
#define tePciSc_MIPS 0x30
#define tePciSc_CoProcessor 0x40

#define tePciBc_SerialBusController 0x0c
#define tePciSc_FireWire 0x00
#define tePciSc_Ieee1394 0x00
#define tePciSc_AccessBus 0x01
#define tePciSc_Ssa 0x02
#define tePciSc_Usb 0x03
#define tePciSc_FibreChannel 0x04
#define tePciSc_SystemManagementBus 0x05
#define tePciSc_InfiniBand 0x06
#define tePciSc_Ipmi 0x07
#define tePciSc_SercosInterfaceStandard 0x08
#define tePciSc_CanBus 0x09

#define tePciBc_WirelessController 0x0d
#define tePciSc_IrdaCompatibleController 0x00
#define tePciSc_ConsumerIrController 0x01
#define tePciSc_RfController 0x10
#define tePciSc_BluetoothController 0x11
#define tePciSc_BroadbandController 0x12
#define tePciSc_Ethernet802_11aController 0x20
#define tePciSc_Ethernet802_11bController 0x20
#define tePciSc_OtherWirelessController 0x80

#define tePciBc_IntellegentIoController 0x0e

#define tePciBc_SatelliteCommunicationController 0x0f
#define tePciSc_Tv 0x01
#define tePciSc_Audio 0x02
#define tePciSc_Voice 0x03
#define tePciSc_Data 0x04

#define tePciBc_EncryptionDecryptionController 0x10
#define tePciSc_NetworkAndComputingCrypto 0x00
#define tePciSc_EntertainmentCrypto 0x10
#define tePciSc_OtherCrypto 0x80

#define tePciBc_DataAcquisitionAndSignalProcessingController 0x11
#define tePciSc_DpioModules 0x00
#define tePciSc_PerformanceCounters 0x01
#define tePciSc_CommSyncPlusTimeAndFreq 0x10
#define tePciSc_ManagementCard 0x20
#define tePciSc_OtherDataAcquisitionSignalProcessingController 0x80

#define tePciBc_Unknown 0xff

#define tePciBc_EncryptionDecryptionController 0x10

// Standard configuration space offsets/sizes
// note that sizes are in bytes
#define TEMU_PCI_CONFIG_VENDOR_ID_OFFSET 0
#define TEMU_PCI_CONFIG_VENDOR_ID_SIZE 2
#define TEMU_PCI_CONFIG_DEVICE_ID_OFFSET 2
#define TEMU_PCI_CONFIG_DEVICE_ID_SIZE 2
#define TEMU_PCI_CONFIG_COMMAND_OFFSET 4
#define TEMU_PCI_CONFIG_COMMAND_SIZE 2
#define TEMU_PCI_CONFIG_STATUS_OFFSET 6
#define TEMU_PCI_CONFIG_STATUS_SIZE 2
#define TEMU_PCI_CONFIG_REVISION_ID_OFFSET 8
#define TEMU_PCI_CONFIG_REVISION_ID_SIZE 1
#define TEMU_PCI_CONFIG_CLASS_CODE_OFFSET 9
#define TEMU_PCI_CONFIG_CLASS_CODE_SIZE 3
#define TEMU_PCI_CONFIG_CACHELINE_SIZE_OFFSET 12
#define TEMU_PCI_CONFIG_CACHELINE_SIZE_SIZE 1
#define TEMU_PCI_CONFIG_LATENCY_TIMER_OFFSET 13
#define TEMU_PCI_CONFIG_LATENCY_TIMER_SIZE 1
#define TEMU_PCI_CONFIG_HEADER_TYPE_OFFSET 14
#define TEMU_PCI_CONFIG_HEADER_TYPE_SIZE 1
#define TEMU_PCI_CONFIG_BIST_OFFSET 15
#define TEMU_PCI_CONFIG_BIST_SIZE 1

// Type 0 header fields
#define TEMU_PCI_TYPE_00_BAR_0_OFFSET 0x10
#define TEMU_PCI_TYPE_00_BAR_0_SIZE 4
#define TEMU_PCI_TYPE_00_BAR_1_OFFSET 0x14
#define TEMU_PCI_TYPE_00_BAR_1_SIZE 4
#define TEMU_PCI_TYPE_00_BAR_2_OFFSET 0x18
#define TEMU_PCI_TYPE_00_BAR_2_SIZE 4
#define TEMU_PCI_TYPE_00_BAR_3_OFFSET 0x1c
#define TEMU_PCI_TYPE_00_BAR_3_SIZE 4
#define TEMU_PCI_TYPE_00_BAR_4_OFFSET 0x20
#define TEMU_PCI_TYPE_00_BAR_4_SIZE 4
#define TEMU_PCI_TYPE_00_BAR_5_OFFSET 0x24
#define TEMU_PCI_TYPE_00_BAR_5_SIZE 4
#define TEMU_PCI_TYPE_00_CARDBUS_CIC_POINTER_OFFSET 0x28
#define TEMU_PCI_TYPE_00_CARDBUS_CIC_POINTER_SIZE 4
#define TEMU_PCI_TYPE_00_SUBSYSTEM_VENDOR_ID_OFFSET 0x2c
#define TEMU_PCI_TYPE_00_SUBSYSTEM_VENDOR_ID_SIZE 2
#define TEMU_PCI_TYPE_00_SUBSYSTEM_ID_OFFSET 0x2e
#define TEMU_PCI_TYPE_00_SUBSYSTEM_ID_SIZE 2
#define TEMU_PCI_TYPE_00_EXPANSION_ROM_BASE_ADDRESS_OFFSET 0x30
#define TEMU_PCI_TYPE_00_EXPANSION_ROM_BASE_ADDRESS_SIZE 4
#define TEMU_PCI_TYPE_00_CAPABILITIES_POINTER_OFFSET 0x34
#define TEMU_PCI_TYPE_00_CAPABILITIES_POINTER_SIZE 1
#define TEMU_PCI_TYPE_00_INTERRUPT_LINE_OFFSET 0x3c
#define TEMU_PCI_TYPE_00_INTERRUPT_LINE_SIZE 1
#define TEMU_PCI_TYPE_00_INTERRUPT_PIN_OFFSET 0x3d
#define TEMU_PCI_TYPE_00_INTERRUPT_PIN_SIZE 1
#define TEMU_PCI_TYPE_00_MIN_GNT_OFFSET 0x3e
#define TEMU_PCI_TYPE_00_MIN_GNT_SIZE 1
#define TEMU_PCI_TYPE_00_MAX_LAT_OFFSET 0x3f
#define TEMU_PCI_TYPE_00_MAX_LAT_SIZE 1

#define TEMU_PCI_TYPE_01_BAR_0_OFFSET 0x10
#define TEMU_PCI_TYPE_01_BAR_0_SIZE 4
#define TEMU_PCI_TYPE_01_BAR_1_OFFSET 0x14
#define TEMU_PCI_TYPE_01_BAR_1_SIZE 4
#define TEMU_PCI_TYPE_01_PRIMARY_BUS_NUMBER_OFFSET 0x18
#define TEMU_PCI_TYPE_01_PRIMARY_BUS_NUMBER_SIZE 1
#define TEMU_PCI_TYPE_01_SECONDARY_BUS_NUMBER_OFFSET 0x19
#define TEMU_PCI_TYPE_01_SECONDARY_BUS_NUMBER_SIZE 1
#define TEMU_PCI_TYPE_01_SUBORDINATE_BUS_NUMBER_OFFSET 0x1a
#define TEMU_PCI_TYPE_01_SUBORDINATE_BUS_NUMBER_SIZE 1
#define TEMU_PCI_TYPE_01_SECONDARY_LATENCY_TIMER_OFFSET 0x1b
#define TEMU_PCI_TYPE_01_SECONDARY_LATENCY_TIMER_SIZE 1
#define TEMU_PCI_TYPE_01_IO_BASE_OFFSET 0x1c
#define TEMU_PCI_TYPE_01_IO_BASE_SIZE 1
#define TEMU_PCI_TYPE_01_IO_LIMIT_OFFSET 0x1d
#define TEMU_PCI_TYPE_01_IO_LIMIT_SIZE 1
#define TEMU_PCI_TYPE_01_SECONDARY_STATUS_OFFSET 0x1e
#define TEMU_PCI_TYPE_01_SECONDARY_STATUS_SIZE 2
#define TEMU_PCI_TYPE_01_MEMORY_BASE_OFFSET 0x20
#define TEMU_PCI_TYPE_01_MEMORY_BASE_SIZE 2
#define TEMU_PCI_TYPE_01_MEMORY_LIMIT_OFFSET 0x22
#define TEMU_PCI_TYPE_01_MEMORY_LIMIT_SIZE 2
#define TEMU_PCI_TYPE_01_PREFETCHABLE_MEMORY_BASE_OFFSET 0x24
#define TEMU_PCI_TYPE_01_PREFETCHABLE_MEMORY_BASE_SIZE 2
#define TEMU_PCI_TYPE_01_PREFETCHABLE_MEMORY_LIMIT_OFFSET 0x26
#define TEMU_PCI_TYPE_01_PREFETCHABLE_MEMORY_LIMIT_SIZE 2
#define TEMU_PCI_TYPE_01_PREFETCHABLE_BASE_UPPER_32_OFFSET 0x28
#define TEMU_PCI_TYPE_01_PREFETCHABLE_BASE_UPPER_32_SIZE 4
#define TEMU_PCI_TYPE_01_PREFETCHABLE_LIMIT_UPPER_32_OFFSET 0x2c
#define TEMU_PCI_TYPE_01_PREFETCHABLE_LIMIT_UPPER_32_SIZE 4
#define TEMU_PCI_TYPE_01_IO_BASE_UPPER_16_OFFSET 0x30
#define TEMU_PCI_TYPE_01_IO_BASE_UPPER_16_SIZE 2
#define TEMU_PCI_TYPE_01_IO_LIMIT_UPPER_16_OFFSET 0x32
#define TEMU_PCI_TYPE_01_IO_LIMIT_UPPER_16_SIZE 2
#define TEMU_PCI_TYPE_01_CAPABILITIES_POINTER_OFFSET 0x34
#define TEMU_PCI_TYPE_01_CAPABILITIES_POINTER_SIZE 1
#define TEMU_PCI_TYPE_01_EXPANSION_ROM_BASE_ADDRESS_OFFSET 0x38
#define TEMU_PCI_TYPE_01_EXPANSION_ROM_BASE_ADDRESS_SIZE 4
#define TEMU_PCI_TYPE_01_INTERRUPT_LINE_OFFSET 0x3c
#define TEMU_PCI_TYPE_01_INTERRUPT_LINE_SIZE 1
#define TEMU_PCI_TYPE_01_INTERRUPT_PIN_OFFSET 0x3d
#define TEMU_PCI_TYPE_01_INTERRUPT_PIN_SIZE 1
#define TEMU_PCI_TYPE_01_BRIDGE_CONTROL_OFFSET 0x3e
#define TEMU_PCI_TYPE_01_BRIDGE_CONTROL_SIZE 2

#endif // TEMU_PCI_DEFINE_H
