//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2022
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_MODELS_STRING_BREAKPOINT
#define TEMU_MODELS_STRING_BREAKPOINT

#include <stdint.h>
#include "temu-c/Support/Objsys.h"

#ifdef __cplusplus
extern "C" {
#endif

/*!
  Simple interface to get recorded line data from e.g. the console model.
 */

typedef struct temu_StringBreakpointIface {
  //! print all breakpoints with their indexes
  void (*printBreakpointList)(temu_Object *Obj);
  //! add log line to use for break
  void (*addBreakpoint)(temu_Object *Obj, const char* regex);
  //! delete breakpoint with index = idx, if idx = -1 deleate all
  void (*deleteBreakpoint)(temu_Object *Obj, int idx);
} temu_StringBreakpointIface;
#define TEMU_STRING_BREAKPOINT_IFACE_TYPE "StringBreakpointIface"
TEMU_IFACE_REFERENCE_TYPE(temu_StringBreakpoint);


#ifdef __cplusplus
}
#endif

#endif /* ! TEMU_MODELS_STRING_BREAKPOINT */
