//===-- temu-c/Extensions128.h - 128-bit extensions -------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2023
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//
#ifndef TEMU_EXTENSIONS_128_H
#define TEMU_EXTENSIONS_128_H
#include "temu-c/Support/Memory.h"

typedef __int128_t temu_Int128;
typedef __uint128_t temu_UInt128;

typedef union {
  temu_ExtIRInstruction IRInst;
  temu_UInt128 Bits;
} temu_ExtendedIR;

static inline temu_UInt128
temu_atomicLoadU128(temu_UInt128 *p)
{
  return __sync_val_compare_and_swap(p, 0, 0);
}

static inline temu_UInt128
temu_atomicCompareAndSwapU128(temu_UInt128 *p, temu_UInt128 expected, temu_UInt128 exchangeVal)
{
  return __sync_val_compare_and_swap(p, expected, exchangeVal);
}


#endif // !TEMU_EXTENSIONS_128_H
