//===-- temu-c/Sparc.h - SPARCv8 Architecture Interfaces --------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2015
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_SPARC_H
#define TEMU_SPARC_H

#include "temu-c/Memory/Memory.h"
#include "temu-c/Support/Objsys.h"
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*temu_SparcAsrHandler)(void *Cpu, uint32_t Instr);
typedef void (*temu_SparcAsiHandler)(void *Cpu, temu_MemTransaction *MT);

/*!
  Interface for SPARC specific functionality
 */
typedef struct temu_SparcV8Iface {
  unsigned (*getWindowCount)(const void *Cpu);
  uint32_t (*getWindowedReg)(const void *Cpu, int Window, unsigned Reg);
  void (*setWindowedReg)(void *Cpu, int Window, unsigned Reg, uint32_t Value);
  void (*setAsiHandler)(void *Cpu, unsigned Asi, int IsWriteAsi,
                        temu_SparcAsiHandler AsiHandler);

  // Should normally exist as property as well
  uint32_t (*getAsr)(const void *Cpu, unsigned Asr);
  void (*setAsr)(void *Cpu, unsigned Asr, uint32_t Value);
  void (*setAsrReadHandler)(void *Cpu, unsigned Asr,
                            temu_SparcAsrHandler AsrHandler);
  void (*setAsrWriteHandler)(void *Cpu, unsigned Asr,
                             temu_SparcAsrHandler AsrHandler);

  // Should go through property instead
  uint32_t (*getPsr)(const void *Cpu);
  void (*setPsr)(void *Cpu, uint32_t Value);
  uint32_t (*getTbr)(const void *Cpu);
  void (*setTbr)(void *Cpu, uint32_t Value);
  uint32_t (*getWim)(const void *Cpu);
  void (*setWim)(void *Cpu, uint32_t Value);

  uint32_t (*getNPc)(const void *Cpu);
  void (*setNPc)(void *Cpu, uint32_t Value);

  uint32_t (*getFsr)(const void *Cpu);
  void (*setFsr)(void *Cpu, uint32_t Value);

  uint32_t (*getCsr)(const void *Cpu);
  void (*setCsr)(void *Cpu, uint32_t Value);

  void (*setAsiProbeHandler)(
      void *obj, unsigned asi,
      void (*asi_probe_handler)(void *cpu, temu_MemTransaction *mt));

} temu_SparcV8Iface;
#define TEMU_SPARCV8_IFACE_TYPE "SparcIface"
TEMU_IFACE_REFERENCE_TYPE(temu_SparcV8);


typedef struct {
  void (*setBootWord)(void *obj, uint32_t bootWord);
  uint32_t (*getBootWord)(void *obj);

  void (*powerOn)(void *Cpu);
  void (*powerOff)(void *Cpu);
  void (*start)(void *Cpu);
  void (*cancelStart)(void *Cpu);
  void (*stop)(void *Cpu);
  void (*cancelStop)(void *Cpu);
  void (*wakeUp)(void *Cpu);
  void (*cancelWakeUp)(void *Cpu);
} temu_Leon5Iface;
#define TEMU_LEON5_IFACE_TYPE "temu::Leon5Iface"
TEMU_IFACE_REFERENCE_TYPE(temu_Leon5);


#ifdef __cplusplus
}
#endif

#endif /* ! TEMU_SPARC_H */
