//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2022
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_HOST_DISASSEMBLER_H
#define TEMU_HOST_DISASSEMBLER_H

#include "temu-c/Support/Objsys.h"
#include <stdint.h>

#define TEMU_DISASSEMBLER_ALTERNATE_SYNTAX UINT64_C(1)
#define TEMU_DISASSEMBLER_LATENCY UINT64_C(2)


/*!
    Block disassembler disassembles data blocks of code.

    The main purpose is to disassemble host code,
    however the interface is genericly named
    so it could be used for other purposes in the future.

    The disassemble method is supposed to return a thread local C-string,
    that is valid until the next call of the function.
    Consequently, you do not need to free or in other ways worry of the string.

    \field disassemble Disassembly function.
 */

typedef struct {
  const char *(*disassemble)(void *Obj, const uint8_t *Buffer, size_t BuffSize,
                             uint64_t Flags);
} temu_BlockDisassemblerIface;

#define TEMU_BLOCK_DISASSEMBLER_IFACE_TYPE "temu::BlockDisassemblerIface"
TEMU_IFACE_REFERENCE_TYPE(temu_BlockDisassembler);

#endif // !TEMU_HOST_DISASSEMBLER_H

