//===-- temu-c/PCIeHelper.h - PCIe API --------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2020
// Authors: Daria Vorotnikova <davo (at) terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_SUPPORT_PCIe_H
#define TEMU_SUPPORT_PCIe_H

//------------------------------------------------------------------------------
// WARNING!!! WARNING!!!    EXPERIMENTAL API   WARNING!!!  WARNING!!! WARNING!!!
//
// BE WARNED THAT THIS API IS EXPERIMENTAL, UNSTABLE AND NOT WELL
// TESTED.  IN PARTICULAR, ASSUME THAT DOCUMENTATION FOR THE API IS
// NOT UP TO DATE AND IT MAY CRASH, CAUSE DEADLOCKS OR BEHAVE BADLY IN
// OTHER WAYS ON OCCASIONS. FURTHER THE API IS SUBJECT TO CHANGE
// WITHOUT NOTICE.
//------------------------------------------------------------------------------

#include "temu-c/Support/Attributes.h"
#include "temu-c/Bus/PCIExpress.h"

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/*!
 * Write value to PCIe config to the register with given offset.
 *
 * \param devConf PCIe configuration
 * \param offset register offset in memory map.
 * \param value new value fot the register
 */
TEMU_API void
temu_writePCIeConfigRegister(temu_PCIExpressDevice *devConf, uint32_t offset,
                             uint32_t value);

/*!
 * Read register value from PCIe configuration
 *
 * \param DevConf PCIe configuration
 * \param offset register offset in memory map.
 * 
 * \result return register value.
 */
TEMU_API temu_Propval
temu_readPCIeConfigRegister(temu_PCIExpressDevice *DevConf, uint32_t offset);

TEMU_API void
temu_pciExpressDeviceRegister(temu_Class *C);

TEMU_API void
temu_pciExpressBridgeRegister(temu_Class *C);

TEMU_API void
temu_pciExpressBusRegister(temu_Class *C);
#ifdef __cplusplus
}
#endif

#endif // !TEMU_SUPPORT_PCIe_H
