//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2017
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

/*
 * EXPERIMENTAL INTERFACE: This interface is undergoing public review
 */
#ifndef TEMU_MODELS_POWER_H
#define TEMU_MODELS_POWER_H

#include "temu-c/Support/Objsys.h"


#ifdef __cplusplus
extern "C" {
#endif

//! Used to indicate whether a model is powered on
typedef enum {
  tePS_Off,     //!< System is powered off
  tePS_On,      //!< System is powered on
} temu_PowerState;

//! Power interface
typedef struct {
  //! Power on device
  void (*powerOn)(void *Obj);
  //! Power off device
  void (*powerOff)(void *Obj);
  //! Get current power state
  temu_PowerState (*getPowerState)(void *Obj);
} temu_PowerIface;

#define TEMU_POWER_IFACE_TYPE "PowerIface"
TEMU_IFACE_REFERENCE_TYPE(temu_Power);


// Power line interface is experimental
typedef struct {
  void (*setCurrent)(void *Obj, double Current);
  double (*getCurrent)(void *Obj);
  void (*setVoltage)(void *Obj, double Voltage);
  double (*getVoltage)(void *Obj);
} temu_PowerLineIface;

#define TEMU_POWER_LINE_IFACE_TYPE "PowerLineIface"
TEMU_IFACE_REFERENCE_TYPE(temu_PowerLine);


#ifdef __cplusplus
}
#endif

#endif /* !TEMU_MODELS_POWER_H */
