//===-- temu-c/DataLoggers.h - Data logger functions ------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2016, 2021
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//
#ifndef TEMU_SUPPORT_DATALOGGERS
#define TEMU_SUPPORT_DATALOGGERS

#include <stdint.h>
#include "temu-c/Support/Attributes.h"
#ifdef __cplusplus
extern "C" {
#endif

/*!
  Get number of lines in log.
  \param Obj Data-logging object
  \result Number of logged lines
 */
TEMU_API uint64_t temu_lineDataGetLineCount(void *Obj);

/*!
  Get line with number.
  \param Obj Data-logging object
  \param Line Line number to read out
  \result A string that is borrowed.
 */
TEMU_API const char* temu_lineDataGetLine(void *Obj, uint64_t Line);

#ifdef __cplusplus
}
#endif

#endif /* ! TEMU_SUPPORT_DATALOGGERS */
