//===-- temu-c/Profiling.h - TEMU Profiling and Coverage --------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2021
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_PROFILING_H
#define TEMU_PROFILING_H

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/*!
 * Experimental coverage support
 * 
 * This file declares a number of functions useful for working with coverage.
 * 
 * The support here is experimental.
 */

/*!
 * Write branch counters in YAML format
 * 
 * Coverage is stored using physical addresses.
 * \param fileName Name of file to write
 * \result 0 if successful
 */
int xemu_writeBranchCounters(const char *fileName);

/*!
 * Get a branch counter for the specific arc
 * \param src Source physical address
 * \param tgt Target physical address
 * \result Pointer to the counter
 */
uint64_t * xemu_getBranchCounter(uint64_t src, uint64_t tgt);

#ifdef __cplusplus
}
#endif


#endif // !TEMU_PROFILING_H
