//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2015
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_DYNAMIC_INVOCATION_H
#define TEMU_DYNAMIC_INVOCATION_H

#include "temu-c/Support/CommandLine.h"
#include "temu-c/Support/Objsys.h"
#include <stdbool.h>
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

#define TEMU_DYN_CALL_IFACE_NAME "DynamicInvocationIface"

typedef struct {
  temu_Propval (*call)(temu_Object *Obj, const char *cmd, int posArgc,
                       temu_CmdArg positionalArgs[]);

  bool (*hasCommand)(temu_Object *Obj, const char *cmd);
  temu_Type (*getArgType)(temu_Object *Obj, const char *cmdName,
                          const char *argName);
} temu_DynCallIface;
#define TEMU_DYN_CALL_IFACE_TYPE "DynCallIface"
TEMU_IFACE_REFERENCE_TYPE(temu_DynCall);

#ifdef __cplusplus
}
#endif

#endif /* ! TEMU_DYNAMIC_INVOCATION_H */
