from temu.c.support.objsys import *
from ctypes import *
TEMUSupport = CDLL('libTEMUSupport.so.4')

teMK_RAM = 0
teMK_ROM = 1
teMK_MMIO = 2
teMK_IO = 2
teMK_MemSpace = 4
teMK_Last = 4


teMA_Break = 1
teMA_WatchRead = 2
teMA_WatchWrite = 4
teMA_Upset = 8
teMA_Faulty = 16
teMA_User1 = 32
teMA_User2 = 64
teMA_User3 = 128



class MemAccessIface(Structure):
  pass
MemAccessIface._fields_ = [  ]

teMS_IOReads = 0
teMS_IOWrites = 1
teMS_SelfModifyingCodeWrites = 2
teMS_CodeWrites = 3
teMS_LocksTaken = 4
teMS_IOReadTime = 5
teMS_IOWriteTime = 6
teMS_LockTime = 7



class MemorySpaceIface(Structure):
  pass
MemorySpaceIface._fields_ = [ 
    ('mapDevice', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64, POINTER(Object), c_uint32)),
    ('setAttr', CFUNCTYPE(None, c_void_p, c_uint64, c_uint64, c_uint)),
    ('clearAttr', CFUNCTYPE(None, c_void_p, c_uint64, c_uint64, c_uint)),
    ('getAttrs', CFUNCTYPE(c_ubyte, c_void_p, c_uint64)),
    ('mapDeviceWithNamedIface', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64, POINTER(Object), c_char_p, c_uint32)),
    ('unmapRange', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64)),
    ('mapDeviceWithIface', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64, POINTER(Object), POINTER(MemAccessIface), c_uint32)),
    ('getStat', CFUNCTYPE(c_uint64, c_void_p, c_uint))  ]


class MemorySpaceIfaceRef(Structure):
  pass
MemorySpaceIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(MemorySpaceIface))  ]

class MemorySpaceIfaceRefArray(Structure):
  pass
MemorySpaceIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(MemorySpaceIfaceRef))  ]

class IRInstruction(Structure):
  pass
IRInstruction._fields_ = [ 
    ('Instruction', c_uint32),
    ('Operands', c_uint32)  ]

class ExtIRInstruction(Structure):
  pass
ExtIRInstruction._fields_ = [ 
    ('Inst', IRInstruction),
    ('ExtParam', c_uint64)  ]

class PDCIface(Structure):
  pass
PDCIface._fields_ = [ 
    ('getPDCForCpu', CFUNCTYPE(c_void_p, c_void_p, c_int, c_uint64)),
    ('allocPDCForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('disposePDCForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('writePDCForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64, c_void_p)),
    ('clearPDCForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('setPseudoOpHandlerForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint, c_ulong)),
    ('installTrampolineForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64, CFUNCTYPE(None, c_void_p))),
    ('installProfileForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('removeProfileForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('installIdleForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64, c_uint32)),
    ('removeIdleForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('setBTForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64, c_void_p)),
    ('allocPDCChainForCpu', CFUNCTYPE(POINTER(ExtIRInstruction), c_void_p, c_int, c_uint64)),
    ('releasePDCChainForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('irToPAForCpu', CFUNCTYPE(c_uint64, c_void_p, c_int, c_uint64)),
    ('installSkipForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64, c_uint)),
    ('removeSkipForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('installCallForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64, c_uint)),
    ('removeCallForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64))  ]

class PDCIfaceRef(Structure):
  pass
PDCIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(PDCIface))  ]

class PDCIfaceRefArray(Structure):
  pass
PDCIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(PDCIfaceRef))  ]
memoryRead = TEMUSupport.temu_memoryRead
memoryRead.argtypes = [c_void_p, POINTER(c_uint8), c_uint64, c_uint32, c_int]
memoryRead.restype = c_int

memoryWrite = TEMUSupport.temu_memoryWrite
memoryWrite.argtypes = [c_void_p, c_uint64, POINTER(c_uint8), c_uint32, c_int]
memoryWrite.restype = c_int

memoryReadData = TEMUSupport.temu_memoryReadData
memoryReadData.argtypes = [c_void_p, c_uint64, POINTER(c_uint8), c_uint, c_uint32, c_uint]
memoryReadData.restype = c_int

memoryWriteData = TEMUSupport.temu_memoryWriteData
memoryWriteData.argtypes = [c_void_p, c_uint64, POINTER(c_uint8), c_uint, c_uint32, c_uint]
memoryWriteData.restype = c_int

memoryMap = TEMUSupport.temu_memoryMap
memoryMap.argtypes = [c_void_p, c_uint64, c_uint64, c_void_p, c_uint32]
memoryMap.restype = c_int

memoryMapNamedIface = TEMUSupport.temu_memoryMapNamedIface
memoryMapNamedIface.argtypes = [c_void_p, c_uint64, c_uint64, c_void_p, c_char_p, c_uint32]
memoryMapNamedIface.restype = c_int

memoryMapNamedIface2 = TEMUSupport.temu_memoryMapNamedIface2
memoryMapNamedIface2.argtypes = [c_void_p, c_uint64, c_uint64, c_void_p, c_char_p, c_uint, c_uint32]
memoryMapNamedIface2.restype = c_int

memorySetAttr = TEMUSupport.temu_memorySetAttr
memorySetAttr.argtypes = [c_void_p, c_uint64, c_uint64, c_uint]
memorySetAttr.restype = None

memoryClearAttr = TEMUSupport.temu_memoryClearAttr
memoryClearAttr.argtypes = [c_void_p, c_uint64, c_uint64, c_uint]
memoryClearAttr.restype = None

memoryGetAttrs = TEMUSupport.temu_memoryGetAttrs
memoryGetAttrs.argtypes = [c_void_p, c_uint64]
memoryGetAttrs.restype = c_ubyte

memoryReadPhys16 = TEMUSupport.temu_memoryReadPhys16
memoryReadPhys16.argtypes = [c_void_p, c_uint64, POINTER(c_uint16)]
memoryReadPhys16.restype = c_int

memoryReadPhys16Little = TEMUSupport.temu_memoryReadPhys16Little
memoryReadPhys16Little.argtypes = [c_void_p, c_uint64, POINTER(c_uint16)]
memoryReadPhys16Little.restype = c_int

memoryReadPhys32 = TEMUSupport.temu_memoryReadPhys32
memoryReadPhys32.argtypes = [c_void_p, c_uint64, POINTER(c_uint32)]
memoryReadPhys32.restype = c_int

memoryReadPhys32Little = TEMUSupport.temu_memoryReadPhys32Little
memoryReadPhys32Little.argtypes = [c_void_p, c_uint64, POINTER(c_uint32)]
memoryReadPhys32Little.restype = c_int

memoryWritePhys16 = TEMUSupport.temu_memoryWritePhys16
memoryWritePhys16.argtypes = [c_void_p, c_uint64, c_uint16]
memoryWritePhys16.restype = c_int

memoryWritePhys32 = TEMUSupport.temu_memoryWritePhys32
memoryWritePhys32.argtypes = [c_void_p, c_uint64, c_uint32]
memoryWritePhys32.restype = c_int

memoryWritePhys32Little = TEMUSupport.temu_memoryWritePhys32Little
memoryWritePhys32Little.argtypes = [c_void_p, c_uint64, c_uint32]
memoryWritePhys32Little.restype = c_int

normaliseWrite32 = TEMUSupport.temu_normaliseWrite32
normaliseWrite32.argtypes = [c_uint32, c_uint32, c_int, c_int]
normaliseWrite32.restype = c_uint32

normaliseRead32 = TEMUSupport.temu_normaliseRead32
normaliseRead32.argtypes = [c_uint32, c_int, c_int]
normaliseRead32.restype = c_uint32

normaliseRead16 = TEMUSupport.temu_normaliseRead16
normaliseRead16.argtypes = [c_uint16, c_int, c_int]
normaliseRead16.restype = c_uint16

normaliseWrite16 = TEMUSupport.temu_normaliseWrite16
normaliseWrite16.argtypes = [c_uint16, c_uint16, c_int, c_int]
normaliseWrite16.restype = c_uint16

memoryInstallTrampoline = TEMUSupport.temu_memoryInstallTrampoline
memoryInstallTrampoline.argtypes = [c_void_p, c_uint64, CFUNCTYPE(None, c_void_p)]
memoryInstallTrampoline.restype = c_int

irToPhys = TEMUSupport.temu_irToPhys
irToPhys.argtypes = [c_void_p, c_ulong]
irToPhys.restype = c_uint64

irToPhysForCpu = TEMUSupport.temu_irToPhysForCpu
irToPhysForCpu.argtypes = [c_void_p, c_int, c_ulong]
irToPhysForCpu.restype = c_uint64

from temu.c.support.objsys import *
from ctypes import *
TEMUSupport = CDLL('libTEMUSupport.so.4')

teMK_RAM = 0
teMK_ROM = 1
teMK_MMIO = 2
teMK_IO = 2
teMK_MemSpace = 4
teMK_Last = 4


teMA_Break = 1
teMA_WatchRead = 2
teMA_WatchWrite = 4
teMA_Upset = 8
teMA_Faulty = 16
teMA_User1 = 32
teMA_User2 = 64
teMA_User3 = 128



class MemAccessIface(Structure):
  pass
MemAccessIface._fields_ = [  ]

teMS_IOReads = 0
teMS_IOWrites = 1
teMS_SelfModifyingCodeWrites = 2
teMS_CodeWrites = 3
teMS_LocksTaken = 4
teMS_IOReadTime = 5
teMS_IOWriteTime = 6
teMS_LockTime = 7



class MemorySpaceIface(Structure):
  pass
MemorySpaceIface._fields_ = [ 
    ('mapDevice', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64, POINTER(Object), c_uint32)),
    ('setAttr', CFUNCTYPE(None, c_void_p, c_uint64, c_uint64, c_uint)),
    ('clearAttr', CFUNCTYPE(None, c_void_p, c_uint64, c_uint64, c_uint)),
    ('getAttrs', CFUNCTYPE(c_ubyte, c_void_p, c_uint64)),
    ('mapDeviceWithNamedIface', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64, POINTER(Object), c_char_p, c_uint32)),
    ('unmapRange', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64)),
    ('mapDeviceWithIface', CFUNCTYPE(c_int, c_void_p, c_uint64, c_uint64, POINTER(Object), POINTER(MemAccessIface), c_uint32)),
    ('getStat', CFUNCTYPE(c_uint64, c_void_p, c_uint))  ]


class MemorySpaceIfaceRef(Structure):
  pass
MemorySpaceIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(MemorySpaceIface))  ]

class MemorySpaceIfaceRefArray(Structure):
  pass
MemorySpaceIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(MemorySpaceIfaceRef))  ]

class IRInstruction(Structure):
  pass
IRInstruction._fields_ = [ 
    ('Instruction', c_uint32),
    ('Operands', c_uint32)  ]

class ExtIRInstruction(Structure):
  pass
ExtIRInstruction._fields_ = [ 
    ('Inst', IRInstruction),
    ('ExtParam', c_uint64)  ]

class PDCIface(Structure):
  pass
PDCIface._fields_ = [ 
    ('getPDCForCpu', CFUNCTYPE(c_void_p, c_void_p, c_int, c_uint64)),
    ('allocPDCForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('disposePDCForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('writePDCForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64, c_void_p)),
    ('clearPDCForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('setPseudoOpHandlerForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint, c_ulong)),
    ('installTrampolineForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64, CFUNCTYPE(None, c_void_p))),
    ('installProfileForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('removeProfileForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('installIdleForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64, c_uint32)),
    ('removeIdleForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('setBTForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64, c_void_p)),
    ('allocPDCChainForCpu', CFUNCTYPE(POINTER(ExtIRInstruction), c_void_p, c_int, c_uint64)),
    ('releasePDCChainForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('irToPAForCpu', CFUNCTYPE(c_uint64, c_void_p, c_int, c_uint64)),
    ('installSkipForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64, c_uint)),
    ('removeSkipForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64)),
    ('installCallForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64, c_uint)),
    ('removeCallForCpu', CFUNCTYPE(None, c_void_p, c_int, c_uint64))  ]

class PDCIfaceRef(Structure):
  pass
PDCIfaceRef._fields_ = [ 
    ('Obj', POINTER(Object)),
    ('Iface', POINTER(PDCIface))  ]

class PDCIfaceRefArray(Structure):
  pass
PDCIfaceRefArray._fields_ = [ 
    ('Size', c_uint32),
    ('Reserved', c_uint32),
    ('Ifaces', POINTER(PDCIfaceRef))  ]
memoryRead = TEMUSupport.temu_memoryRead
memoryRead.argtypes = [c_void_p, POINTER(c_uint8), c_uint64, c_uint32, c_int]
memoryRead.restype = c_int

memoryWrite = TEMUSupport.temu_memoryWrite
memoryWrite.argtypes = [c_void_p, c_uint64, POINTER(c_uint8), c_uint32, c_int]
memoryWrite.restype = c_int

memoryReadData = TEMUSupport.temu_memoryReadData
memoryReadData.argtypes = [c_void_p, c_uint64, POINTER(c_uint8), c_uint, c_uint32, c_uint]
memoryReadData.restype = c_int

memoryWriteData = TEMUSupport.temu_memoryWriteData
memoryWriteData.argtypes = [c_void_p, c_uint64, POINTER(c_uint8), c_uint, c_uint32, c_uint]
memoryWriteData.restype = c_int

memoryMap = TEMUSupport.temu_memoryMap
memoryMap.argtypes = [c_void_p, c_uint64, c_uint64, c_void_p, c_uint32]
memoryMap.restype = c_int

memoryMapNamedIface = TEMUSupport.temu_memoryMapNamedIface
memoryMapNamedIface.argtypes = [c_void_p, c_uint64, c_uint64, c_void_p, c_char_p, c_uint32]
memoryMapNamedIface.restype = c_int

memoryMapNamedIface2 = TEMUSupport.temu_memoryMapNamedIface2
memoryMapNamedIface2.argtypes = [c_void_p, c_uint64, c_uint64, c_void_p, c_char_p, c_uint, c_uint32]
memoryMapNamedIface2.restype = c_int

memorySetAttr = TEMUSupport.temu_memorySetAttr
memorySetAttr.argtypes = [c_void_p, c_uint64, c_uint64, c_uint]
memorySetAttr.restype = None

memoryClearAttr = TEMUSupport.temu_memoryClearAttr
memoryClearAttr.argtypes = [c_void_p, c_uint64, c_uint64, c_uint]
memoryClearAttr.restype = None

memoryGetAttrs = TEMUSupport.temu_memoryGetAttrs
memoryGetAttrs.argtypes = [c_void_p, c_uint64]
memoryGetAttrs.restype = c_ubyte

memoryReadPhys16 = TEMUSupport.temu_memoryReadPhys16
memoryReadPhys16.argtypes = [c_void_p, c_uint64, POINTER(c_uint16)]
memoryReadPhys16.restype = c_int

memoryReadPhys16Little = TEMUSupport.temu_memoryReadPhys16Little
memoryReadPhys16Little.argtypes = [c_void_p, c_uint64, POINTER(c_uint16)]
memoryReadPhys16Little.restype = c_int

memoryReadPhys32 = TEMUSupport.temu_memoryReadPhys32
memoryReadPhys32.argtypes = [c_void_p, c_uint64, POINTER(c_uint32)]
memoryReadPhys32.restype = c_int

memoryReadPhys32Little = TEMUSupport.temu_memoryReadPhys32Little
memoryReadPhys32Little.argtypes = [c_void_p, c_uint64, POINTER(c_uint32)]
memoryReadPhys32Little.restype = c_int

memoryWritePhys16 = TEMUSupport.temu_memoryWritePhys16
memoryWritePhys16.argtypes = [c_void_p, c_uint64, c_uint16]
memoryWritePhys16.restype = c_int

memoryWritePhys32 = TEMUSupport.temu_memoryWritePhys32
memoryWritePhys32.argtypes = [c_void_p, c_uint64, c_uint32]
memoryWritePhys32.restype = c_int

memoryWritePhys32Little = TEMUSupport.temu_memoryWritePhys32Little
memoryWritePhys32Little.argtypes = [c_void_p, c_uint64, c_uint32]
memoryWritePhys32Little.restype = c_int

normaliseWrite32 = TEMUSupport.temu_normaliseWrite32
normaliseWrite32.argtypes = [c_uint32, c_uint32, c_int, c_int]
normaliseWrite32.restype = c_uint32

normaliseRead32 = TEMUSupport.temu_normaliseRead32
normaliseRead32.argtypes = [c_uint32, c_int, c_int]
normaliseRead32.restype = c_uint32

normaliseRead16 = TEMUSupport.temu_normaliseRead16
normaliseRead16.argtypes = [c_uint16, c_int, c_int]
normaliseRead16.restype = c_uint16

normaliseWrite16 = TEMUSupport.temu_normaliseWrite16
normaliseWrite16.argtypes = [c_uint16, c_uint16, c_int, c_int]
normaliseWrite16.restype = c_uint16

memoryInstallTrampoline = TEMUSupport.temu_memoryInstallTrampoline
memoryInstallTrampoline.argtypes = [c_void_p, c_uint64, CFUNCTYPE(None, c_void_p)]
memoryInstallTrampoline.restype = c_int

irToPhys = TEMUSupport.temu_irToPhys
irToPhys.argtypes = [c_void_p, c_ulong]
irToPhys.restype = c_uint64

irToPhysForCpu = TEMUSupport.temu_irToPhysForCpu
irToPhysForCpu.argtypes = [c_void_p, c_int, c_ulong]
irToPhysForCpu.restype = c_uint64

