//===------------------------------------------------------------*- C++ -*-===//
//
// TEMU: The Terma Emulator
// (c) Terma 2015
// Authors: Mattias Holm <maho (at) terma.com>
//
//===----------------------------------------------------------------------===//

#ifndef TEMU_BUS_SERIAL_H
#define TEMU_BUS_SERIAL_H

#include "temu-c/Support/Objsys.h"
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

//! Serial communications interface
typedef struct temu_SerialIface {
  //! This function will be called when data is written on the serial bus
  void (*write)(void *Obj, uint8_t Data);

  //! Clear to send. Experimental.
  void (*cts)(void *Obj);
} temu_SerialIface;
#define TEMU_SERIAL_IFACE_TYPE "SerialIface"
TEMU_IFACE_REFERENCE_TYPE(temu_Serial);

#ifdef __cplusplus
}
#endif

#endif /* ! TEMU_BUS_SERIAL_H */
