# Interface Example

This plugin shows how to create a simple MMIO model which posts events
when a register is accessed. This primarily shows how to use interface
references.

## Building

The plugin can be built with the Makefile, just type make, but take
into account that if you have installed TEMU in a non-standard
location, then the paths in the makefile need to be adapted.

## Running

Start the temu command line interface and load the plugin as follows:

  temu> import InterfaceExample

First create a processor instance:

  temu> exec leon2.temu

Then create an object:

  temu> InterfaceExample.new name=myModel

And map it into memory:

  temu> memory-map memspace=mem0 addr=0x20000000 length=0x128 object=myModel

Connect to CPU and time source:

  temu> connect a=myModel.cpu b=cpu0:CpuIface
  temu> connect-timesource obj=myModel ts=cpu0
  
Stimulate the model with a test program:

  temu> assemble cpu=cpu0 instr="st %g1, [%g2 + 0]"
  temu> assemble cpu=cpu0 instr="or %g0, 0, %g0"
  temu> assemble cpu=cpu0 instr="ba -1"
  temu> assemble cpu=cpu0 instr="or %g0, 0, %g0"
  temu> set-reg cpu=cpu0 reg="%g2" value=0x20000000
  temu> set-reg cpu=cpu0 reg="%g1" value=42
  temu> step obj=cpu0 steps=10000
  temu> object-info obj=myModel
