from temu.c.support.objsys import *
from ctypes import *
TEMUSupport = CDLL('libTEMUSupport.so.4')


class EventQueue(Structure):
  pass
EventQueue._fields_ = [  ]


class TimeSource(Structure):
  pass
TimeSource._fields_ = [ 
    ('Super', Object),
    ('ParentTimeSource', POINTER(TimeSource)),
    ('Queue', POINTER(EventQueue)),
    ('Frequency', c_int64),
    ('Steps', c_int64),
    ('Level', c_uint),
    ('NextEvent', c_int64),
    ('StartSteps', c_int64),
    ('TargetSteps', c_int64),
    ('InstructionsPerCycle', c_double),
    ('CyclesPerInstruction', c_double)  ]


class Event(Structure):
  pass
Event._fields_ = [ 
    ('Steps', c_int64),
    ('Time', c_int64),
    ('EventId', c_int64),
    ('Flags', c_uint32),
    ('QueueIdx', c_int),
    ('Queue', POINTER(TimeSource)),
    ('Obj', POINTER(Object)),
    ('Func', CFUNCTYPE(None, POINTER(Event))),
    ('Period', c_int64),
    ('RTTime', c_int64),
    ('RTPeriod', c_int64),
    ('TriggerCount', c_int64)  ]

ThreadSafeCb = CFUNCTYPE(None, c_void_p)

eventPublishStruct = TEMUSupport.temu_eventPublishStruct
eventPublishStruct.argtypes = [c_char_p, POINTER(Event), c_void_p, CFUNCTYPE(None, POINTER(Event))]
eventPublishStruct.restype = c_int64

eventDepublish = TEMUSupport.temu_eventDepublish
eventDepublish.argtypes = [c_int64]
eventDepublish.restype = None

eventPublish = TEMUSupport.temu_eventPublish
eventPublish.argtypes = [c_char_p, c_void_p, CFUNCTYPE(None, POINTER(Event))]
eventPublish.restype = c_int64

eventPostSteps = TEMUSupport.temu_eventPostSteps
eventPostSteps.argtypes = [POINTER(TimeSource), c_int64, c_int64, c_uint]
eventPostSteps.restype = None

eventPostCycles = TEMUSupport.temu_eventPostCycles
eventPostCycles.argtypes = [POINTER(TimeSource), c_int64, c_int64, c_uint]
eventPostCycles.restype = None

eventPostNanos = TEMUSupport.temu_eventPostNanos
eventPostNanos.argtypes = [POINTER(TimeSource), c_int64, c_int64, c_uint]
eventPostNanos.restype = None

eventPostSecs = TEMUSupport.temu_eventPostSecs
eventPostSecs.argtypes = [POINTER(TimeSource), c_int64, c_double, c_uint]
eventPostSecs.restype = None

eventPostStack = TEMUSupport.temu_eventPostStack
eventPostStack.argtypes = [POINTER(TimeSource), c_int64, c_uint]
eventPostStack.restype = None

eventPostImmediate = TEMUSupport.temu_eventPostImmediate
eventPostImmediate.argtypes = [POINTER(TimeSource), c_int64, c_uint]
eventPostImmediate.restype = None

eventPostCyclesAbsolute = TEMUSupport.temu_eventPostCyclesAbsolute
eventPostCyclesAbsolute.argtypes = [POINTER(TimeSource), c_int64, c_int64, c_uint]
eventPostCyclesAbsolute.restype = None

eventPostNanosAbsolute = TEMUSupport.temu_eventPostNanosAbsolute
eventPostNanosAbsolute.argtypes = [POINTER(TimeSource), c_int64, c_int64, c_uint]
eventPostNanosAbsolute.restype = None

eventRescheduleCycles = TEMUSupport.temu_eventRescheduleCycles
eventRescheduleCycles.argtypes = [POINTER(TimeSource), c_int64, c_int64, c_uint]
eventRescheduleCycles.restype = None

eventIsScheduled = TEMUSupport.temu_eventIsScheduled
eventIsScheduled.argtypes = [c_int64]
eventIsScheduled.restype = c_int

eventDeschedule = TEMUSupport.temu_eventDeschedule
eventDeschedule.argtypes = [c_int64]
eventDeschedule.restype = None

eventGetCycles = TEMUSupport.temu_eventGetCycles
eventGetCycles.argtypes = [POINTER(TimeSource), c_int64]
eventGetCycles.restype = c_int64

eventGetNanos = TEMUSupport.temu_eventGetNanos
eventGetNanos.argtypes = [POINTER(TimeSource), c_int64]
eventGetNanos.restype = c_int64

eventGetSecs = TEMUSupport.temu_eventGetSecs
eventGetSecs.argtypes = [POINTER(TimeSource), c_int64]
eventGetSecs.restype = c_double

asyncTimerAdd = TEMUSupport.temu_asyncTimerAdd
asyncTimerAdd.argtypes = [POINTER(TimeSource), c_double, c_uint, CFUNCTYPE(None, c_void_p), c_void_p]
asyncTimerAdd.restype = c_int

asyncTimerRemove = TEMUSupport.temu_asyncTimerRemove
asyncTimerRemove.argtypes = [c_int]
asyncTimerRemove.restype = None

asyncSocketAdd = TEMUSupport.temu_asyncSocketAdd
asyncSocketAdd.argtypes = [POINTER(TimeSource), c_int, c_uint, CFUNCTYPE(None, c_void_p), c_void_p]
asyncSocketAdd.restype = c_int

asyncSocketRemove = TEMUSupport.temu_asyncSocketRemove
asyncSocketRemove.argtypes = [c_int, c_uint]
asyncSocketRemove.restype = None

eventPostAsync = TEMUSupport.temu_eventPostAsync
eventPostAsync.argtypes = [POINTER(TimeSource), CFUNCTYPE(None, c_void_p), c_void_p, c_uint]
eventPostAsync.restype = None

eventSetRealTime = TEMUSupport.temu_eventSetRealTime
eventSetRealTime.argtypes = [c_int64]
eventSetRealTime.restype = c_int

eventSetPeriodCycles = TEMUSupport.temu_eventSetPeriodCycles
eventSetPeriodCycles.argtypes = [c_int64, c_int64]
eventSetPeriodCycles.restype = None

eventSetRTPeriodNanos = TEMUSupport.temu_eventSetRTPeriodNanos
eventSetRTPeriodNanos.argtypes = [c_int64, c_int64]
eventSetRTPeriodNanos.restype = None

eventSetRTTime = TEMUSupport.temu_eventSetRTTime
eventSetRTTime.argtypes = [c_int64, c_int64]
eventSetRTTime.restype = None

eventQueueGetFreq = TEMUSupport.temu_eventQueueGetFreq
eventQueueGetFreq.argtypes = [POINTER(TimeSource)]
eventQueueGetFreq.restype = c_uint64

from temu.c.support.objsys import *
from ctypes import *
TEMUSupport = CDLL('libTEMUSupport.so.4')


class EventQueue(Structure):
  pass
EventQueue._fields_ = [  ]


class TimeSource(Structure):
  pass
TimeSource._fields_ = [ 
    ('Super', Object),
    ('ParentTimeSource', POINTER(TimeSource)),
    ('Queue', POINTER(EventQueue)),
    ('Frequency', c_int64),
    ('Steps', c_int64),
    ('Level', c_uint),
    ('NextEvent', c_int64),
    ('StartSteps', c_int64),
    ('TargetSteps', c_int64),
    ('InstructionsPerCycle', c_double),
    ('CyclesPerInstruction', c_double)  ]


class Event(Structure):
  pass
Event._fields_ = [ 
    ('Steps', c_int64),
    ('Time', c_int64),
    ('EventId', c_int64),
    ('Flags', c_uint32),
    ('QueueIdx', c_int),
    ('Queue', POINTER(TimeSource)),
    ('Obj', POINTER(Object)),
    ('Func', CFUNCTYPE(None, POINTER(Event))),
    ('Period', c_int64),
    ('RTTime', c_int64),
    ('RTPeriod', c_int64),
    ('TriggerCount', c_int64)  ]

ThreadSafeCb = CFUNCTYPE(None, c_void_p)

eventPublishStruct = TEMUSupport.temu_eventPublishStruct
eventPublishStruct.argtypes = [c_char_p, POINTER(Event), c_void_p, CFUNCTYPE(None, POINTER(Event))]
eventPublishStruct.restype = c_int64

eventDepublish = TEMUSupport.temu_eventDepublish
eventDepublish.argtypes = [c_int64]
eventDepublish.restype = None

eventPublish = TEMUSupport.temu_eventPublish
eventPublish.argtypes = [c_char_p, c_void_p, CFUNCTYPE(None, POINTER(Event))]
eventPublish.restype = c_int64

eventPostSteps = TEMUSupport.temu_eventPostSteps
eventPostSteps.argtypes = [POINTER(TimeSource), c_int64, c_int64, c_uint]
eventPostSteps.restype = None

eventPostCycles = TEMUSupport.temu_eventPostCycles
eventPostCycles.argtypes = [POINTER(TimeSource), c_int64, c_int64, c_uint]
eventPostCycles.restype = None

eventPostNanos = TEMUSupport.temu_eventPostNanos
eventPostNanos.argtypes = [POINTER(TimeSource), c_int64, c_int64, c_uint]
eventPostNanos.restype = None

eventPostSecs = TEMUSupport.temu_eventPostSecs
eventPostSecs.argtypes = [POINTER(TimeSource), c_int64, c_double, c_uint]
eventPostSecs.restype = None

eventPostStack = TEMUSupport.temu_eventPostStack
eventPostStack.argtypes = [POINTER(TimeSource), c_int64, c_uint]
eventPostStack.restype = None

eventPostImmediate = TEMUSupport.temu_eventPostImmediate
eventPostImmediate.argtypes = [POINTER(TimeSource), c_int64, c_uint]
eventPostImmediate.restype = None

eventPostCyclesAbsolute = TEMUSupport.temu_eventPostCyclesAbsolute
eventPostCyclesAbsolute.argtypes = [POINTER(TimeSource), c_int64, c_int64, c_uint]
eventPostCyclesAbsolute.restype = None

eventPostNanosAbsolute = TEMUSupport.temu_eventPostNanosAbsolute
eventPostNanosAbsolute.argtypes = [POINTER(TimeSource), c_int64, c_int64, c_uint]
eventPostNanosAbsolute.restype = None

eventRescheduleCycles = TEMUSupport.temu_eventRescheduleCycles
eventRescheduleCycles.argtypes = [POINTER(TimeSource), c_int64, c_int64, c_uint]
eventRescheduleCycles.restype = None

eventIsScheduled = TEMUSupport.temu_eventIsScheduled
eventIsScheduled.argtypes = [c_int64]
eventIsScheduled.restype = c_int

eventDeschedule = TEMUSupport.temu_eventDeschedule
eventDeschedule.argtypes = [c_int64]
eventDeschedule.restype = None

eventGetCycles = TEMUSupport.temu_eventGetCycles
eventGetCycles.argtypes = [POINTER(TimeSource), c_int64]
eventGetCycles.restype = c_int64

eventGetNanos = TEMUSupport.temu_eventGetNanos
eventGetNanos.argtypes = [POINTER(TimeSource), c_int64]
eventGetNanos.restype = c_int64

eventGetSecs = TEMUSupport.temu_eventGetSecs
eventGetSecs.argtypes = [POINTER(TimeSource), c_int64]
eventGetSecs.restype = c_double

asyncTimerAdd = TEMUSupport.temu_asyncTimerAdd
asyncTimerAdd.argtypes = [POINTER(TimeSource), c_double, c_uint, CFUNCTYPE(None, c_void_p), c_void_p]
asyncTimerAdd.restype = c_int

asyncTimerRemove = TEMUSupport.temu_asyncTimerRemove
asyncTimerRemove.argtypes = [c_int]
asyncTimerRemove.restype = None

asyncSocketAdd = TEMUSupport.temu_asyncSocketAdd
asyncSocketAdd.argtypes = [POINTER(TimeSource), c_int, c_uint, CFUNCTYPE(None, c_void_p), c_void_p]
asyncSocketAdd.restype = c_int

asyncSocketRemove = TEMUSupport.temu_asyncSocketRemove
asyncSocketRemove.argtypes = [c_int, c_uint]
asyncSocketRemove.restype = None

eventPostAsync = TEMUSupport.temu_eventPostAsync
eventPostAsync.argtypes = [POINTER(TimeSource), CFUNCTYPE(None, c_void_p), c_void_p, c_uint]
eventPostAsync.restype = None

eventSetRealTime = TEMUSupport.temu_eventSetRealTime
eventSetRealTime.argtypes = [c_int64]
eventSetRealTime.restype = c_int

eventSetPeriodCycles = TEMUSupport.temu_eventSetPeriodCycles
eventSetPeriodCycles.argtypes = [c_int64, c_int64]
eventSetPeriodCycles.restype = None

eventSetRTPeriodNanos = TEMUSupport.temu_eventSetRTPeriodNanos
eventSetRTPeriodNanos.argtypes = [c_int64, c_int64]
eventSetRTPeriodNanos.restype = None

eventSetRTTime = TEMUSupport.temu_eventSetRTTime
eventSetRTTime.argtypes = [c_int64, c_int64]
eventSetRTTime.restype = None

eventQueueGetFreq = TEMUSupport.temu_eventQueueGetFreq
eventQueueGetFreq.argtypes = [POINTER(TimeSource)]
eventQueueGetFreq.restype = c_uint64

